{SLS Block 2 constants. Steven S. Pietrobon 21 Dec 1997.
 Revised  7 Feb 1998, 15 Sep 2012, 20 July 2013
 14 Sep 2013 Added second stage optimisation
 19 Oct 2013
 17 Aug 2014 Block II update.
 23 Aug 2014 Heavy Core.}

const Name = 'SLS';

  {Stage 1 constants}
  S1_Name =   'Dark Knights';
  S1_Mp   =  680388.6; {kg, propellant mass}
  S1_Ms   =   96615.2; {kg, burnout mass}
  S1_N    =         2; {no. of boosters}
  S1_D    =    5.2883; {m,  aft-skirt diameter}
  S1_A    =    -0.038; {m^2, hold down posts and retrockets area less Core 
                            overlap area, 0.763 - 0.801 m^2}
  S1_De   =    3.8748; {m,  nozzle average diameter}
  S1_V    =    2756.6; {m/s, vacuum exhaust speed}
  S1_Ta   =     130.2; {s,  action time}
  S1_Td   = 0.986832971065; {s, incremental time}
 
  {Stage 2 constants}
  S2_Name =   'Core';
  S2_Mp1   =  960489; {kg, mainstage propellant mass used, 982663 kg total -
                           10546 kg startup - 7984 kg reserve - 2098 kg residual
                           - 1546 kg cutoff}
  S2_Mp2   =    1546; {kg, cut off propellant mass used}
  S2_Ms    =  129977; {kg, dry mass 119895 + 7984 kg reserve + 2098 kg residual}
  S2_D     =  8.4074; {m,  stage diameter}
  S2_A     =   2.377; {m^2, feed lines, engine fairings, and tunnel
                           2.5*0.608 + 4*0.203 + 0.045 m^2}
  S2_Ts    =    0.76; {s, separation time after MECO}
  S2_Tj    =     330; {s,  time to LAS jettison}

  {Stage 2 engine constants}
  S2_Eng_Name = 'RS-25E';
  S2_N     =       5; {no. of engines}
  S2_F     = 2090664; {N,   vacuum thrust}
  S2_Fs    = 1668298; {N,   sea level thrust}
  S2_V     =  4420.8; {m/s, vacuum exhaust speed}
  S2_I     =    0.01; {thrust incremental ratio}
  S2_R     =    1.11; {thrust ratio}

  {Stage 3 constants}
  S3_Name  = 'Upper Stage';
  {Constants below updated with simulation}
  S3_Mi    =    8899; {kg, interstage mass}
  S3_Mp1   =     771; {kg, startup propellant mass}
  S3_Mp2   =  178029; {kg, mainstage propellant mass used, 181799 kg total -
                           771 kg startup - 2999 kg reserve}
  S3_Ms    =   26997; {kg, cutoff mass, 142 kg RCS propellant + 23856 kg dry +
                           2999 kg reserve}
  S3_Mup   =     217; {kg, total ullage motor propellant}
  S3_Mus   =     201; {kg, total ullage motor empty}
  S3_Fu    =  122315; {N,  total ullage motor vacuum thrust}
  SC_M     =  144108; {kg, Spacecraft mass}

  S3_T1    =     3.4; {s,  time to engine start}
  S3_Ts    =     5.0; {s,  cutoff to seperation time}
  S3_D     =  8.4074; {m,  stage diameter}
  S3_au    =      30; {degrees, ullage motor offset angle}
  S3_Tu    =    3.87; {s,  ullage motor burn time}
  S3_Tu1   =    0.18; {s,  ullage motor burn time before Core separation}
  S3_Tu2   =   11.72; {s,  ullage motor separation after Core separation}

  {Stage 3 engine constants}
  S3_Eng_Name = 'J-2X';
  S3_N     =       2; {no. of engines}
  S3_F     = 1307777; {N,   vacuum thrust}
  S3_V     =  4393.4; {m/s, vacuum exhaust speed, full nozzle}
  S3_De    =   3.048; {m,   nozzle exit diameter}
  S3_Me    =    2472; {kg, engine mass}

  {Spacecraft constants}
  LAS_M    =    7394; {kg, Launch Abort System mass}
  SAJ_M    =     920; {kg, Jettisoned adaptor mass}

  {Launch constants}
  inc      =   28.45; {deg, Kennedy Space Center inclination}
  h_turn   =     110; {m,   pitch over altitude}
  angle1   =    -0.9; {deg, pitch over angle rate for stage 1}
  amax1    =   29.42; {m/s^2, maximum acceleration strain}
  hpmin    =  200000; {m,   minimum orbital altitude}

  {Stage 3 Reference values}
  S3_Mi_r  =    7394; {kg, reference interstage mass}
  S3_M_r   =  237501; {kg, reference third stage mass}
  SC_M_r   =   96910; {kg, reference spacecraft mass}
  SP_M_r = S3_M_r+SC_M_r; {reference stage and payload mass}
  fmax_r   = 7989605; {N,  reference SP maximum force}
  S3_Mi_s = S3_Mi_r/fmax_r; {interstage mass scale factor}

  RCS_M_r  =     136; {kg, reference RCS propellant mass}
  RCS_M_s = RCS_M_r/SP_M_r; {RCS mass scale factor}

  SIVB_M   =  166258; {kg, S-IVB mass}
  SIVB_Mup =    53.5; {kg, S-IVB solid motor ullage propellant mass}
  SIVB_Mus =    61.2; {kg, S-IVB solid motor ullage dry mass}
  SIVB_Fu  =   30159; {N,  S-IVB total ullage motor vacuum thrust for 2 motors}
  SII_M    =  666299; {kg, S-II mass}
  SII_Fu   =  409236; {kg, S-II total ullage motor vacuum thrust for 4 motors}  
  S3_Fu_p = ln(SIVB_Fu/SII_Fu)/ln(SIVB_M/SII_M); {ullage motor thrust power 
                                                 factor}
  S3_Fu_s = SIVB_Fu/exp(S3_Fu_p*ln(SIVB_M)); {ullage motor thrust scale factor}
  S3_Mup_s = SIVB_Mup/SIVB_Fu; {ullage motor propellant mass scale factor}
  S3_Mus_p = 0.848; {ullage motor dry mass power factor}
  S3_Mus_s = SIVB_Mus/exp(S3_Mus_p*ln(SIVB_Mup)); {ullage motor propellant mass 
                                                   scale factor}

  S3_Mp_r =  210966; {kg, reference third stage propellant mass}
  S3_Md_r =   26399; {kg, reference third stage dry mass, includes engines}
  S3_Me_r =    2472; {kg, reference J-2X third stage engine mass}
  S3_N_r  =       2; {kg, reference number of engines}
  S3_Md_p =   0.848; {third stage dry mass power factor}
  S3_Md_s = (S3_Md_r-S3_N_r*S3_Me_r)/exp(S3_Md_p*ln(S3_Mp_r)); {third stage dry 
                                                       mass scale factor}

  S3_Mps  = S3_N*385.5; {kg, third stage startup propellant mass}
  S3_Mpr_r =   3480; {kg, reference third stage reserve propellant mass}
  S3_Mpr_s = S3_Mpr_r/(S3_Mp_r-S3_Mpr_r); {third stage reserve propellant mass
                                           scale factor}