procedure stage4;
{Finds the trajectory of the Orbiter of the Space Shuttle.
 Steven S. Pietrobon 25 Dec 1997. Revised 10 Jan 2000}
var ans:string;
    S3_Mt,S3_Mi_n,SP_M_n,RCS_M_n,S3_Fu_n,S3_Mup_n,S3_Mus_n:double;
    S3_Mp_n,S3_Mpr_n,S3_Md_n,S3_Mp2_n,S3_Ms_n,SC_M_n:double;

begin{stage 4}
  write(question,'Transfer to apogee? ');
  readln(ans);

  if (ans = 'y') or (ans = 'Y') or (ans = '') then
    begin{to orbit}
      f0 := 0.0;
      m1 := 0.0;
      p0 := 0.0;
      dt := 1.0;
      dp := 0.0;
      dF := 0.0;
      dRp := 0.0;
      repeat
        trajectory;
      until 1.0004*h0 > ha;
    end;{to orbit}

  h := (hp+ha)/2;
  dh := ha-h;
  if ha <> hold then
    begin{new max}
      maxanew := maxa - (ha-hamin)*(maxa-maxaold)/(ha-hold);
      hold := ha;
      maxaold := maxa;
    end;{new max}

  writeln;
  writeln('Turn Time = ',tt:5:3,' s, Maximum angle of attack = ',
          maxa*180/pi:7:4,degc);
  writeln(S3_Name,' in Orbit! Remaining propellant = ',m0:1:0,' kg.');
  writeln('Perigee = ',(hp/1000):5:1,' km, Apogee = ',(ha/1000):5:1,
          ' km, Average Altitude = ',(h/1000):5:1,plmic,(dh/1000):3:1,' km');
  writeln('Vacuum and zero gravity delta-V = ',dv:1:0,' m/s');
  writeln('Maximum force = ',fmax:1:0,' N at ',tfmax:4:2,' s');
  writeln('Liftoff thrust = ',flo:1:0,' N at ',alo:5:2,' m/s',sqrc,
          ' for ',mlo:1:0,' kg');
  if simout then
    begin{output parameters}
      writeln('Maximum dynamic pressure = ',Pqmax:1:0,' N at ',tPqmax:5:2,' s');
      writeln('Maximum acceleration = ',a_max:5:2,' m/s',sqrc,' at ',ta_max:5:2,
              ' s');
    end;{output parameters}
  writeln;

  S3_Mt := S3_Mi+S3_Mup+S3_Mus+S3_Mp1+S3_Mp2+S3_Ms+SC_M;
  writeln('  S3_Mt    =  ',S3_Mt:6:0,
          '; {kg, interstage, third stage and payload mass}');
  S3_Mi_n := round(S3_Mi_s*fmax);
  writeln('  S3_Mi    =    ',S3_Mi_n:4:0,'; {kg, interstage mass}');
  writeln('  S3_Mp1   =     ',S3_Mp1:3,'; {kg, startup propellant mass}');
  SP_M_n := S3_Mt-S3_Mi_n;
  RCS_M_n := round(RCS_M_s*SP_M_n);
  S3_Fu_n := round(S3_Fu_s*exp(S3_Fu_p*ln(SP_M_n)));
  S3_Mup_n := round(S3_Mup_s*S3_Fu_n);
  S3_Mus_n := round(S3_Mus_s*exp(S3_Mus_p*ln(S3_Mup_n)));

  S3_Mp_n := S3_Mp1+S3_Mp2-m0;
  S3_Mpr_n := round(S3_Mpr_s*S3_Mp_n);
  S3_Mp_n := S3_Mp_n+S3_Mpr_n;
  S3_Md_n := round(S3_N*S3_Me+S3_Md_s*exp(S3_Md_p*ln(S3_Mp_n)));
  S3_Mp2_n := S3_Mp_n-S3_Mp1-S3_Mpr_n;
  writeln('  S3_Mp2   =  ',S3_Mp2_n:6:0,
          '; {kg, mainstage propellant mass used, ',S3_Mp_n:6:0,' kg total -');
  writeln('                           ',S3_Mp1:3,' kg startup - ',
          S3_Mpr_n:3:0,' kg reserve}');
  S3_Ms_n := RCS_M_n+S3_Md_n+S3_Mpr_n;
  writeln('  S3_Ms    =   ',S3_Ms_n:5:0,'; {kg, cutoff mass, ',RCS_M_n:3:0,
          ' kg RCS propellant + ',S3_Md_n:5:0,' kg dry +');
  writeln('                           ',S3_Mpr_n:4:0,' kg reserve}');
  writeln('  S3_Mup   =     ',S3_Mup_n:3:0,
          '; {kg, total ullage motor propellant}');
  writeln('  S3_Mus   =     ',S3_Mus_n:3:0,'; {kg, total ullage motor empty}');
  writeln('  S3_Fu    =  ',S3_Fu_n:6:0,
          '; {N,  total ullage motor vacuum thrust}');
  SC_M_n := S3_Mt-(S3_Mi_n+S3_Mup_n+S3_Mus_n+S3_Mp1+S3_Mp2_n+S3_Ms_n);
  writeln('  SC_M     =  ',SC_M_n:6:0,'; {kg, Spacecraft mass}');
  writeln;
  writeln('Recommended maxa = ',(maxanew*180/pi):7:4,degc);
  writeln;
end;{stage 4}
