procedure stage3;
{Finds the trajectory of the Upper Stage for the Space Launch System.
 Steven S. Pietrobon 23 Dec 1997. Revised 30 Dec 1997, 20 Jul 2013, 19 Oct 2013}

var S3_T2:double;

begin{stage 3}
  maxa := f3maxa*maxa;
  Ar := pi*sqr(S3_D)/4;
  Ae := 0;
  Me := S3_Mus + S3_Mp1 + S3_Mp2 + S3_Ms + SC_M;
  dp := 0.0;
  dF := 0.0;
  dRp := 0.0;
  Te := S3_T1;
  dt := 1.0;
  traj := air;
  fair := false;
  time_traj;

  writeln(S3_Name,' Ignition!');
  m0 := m0 + S3_Mp1;
  Me := Me - S3_Mp1;
  Te := 2*S3_V*S3_Mp1/(S3_N*S3_F);
  S3_T2 := Te;
  dF := S3_N*S3_F/Te;
  dRp := -dF/S3_V;
  Ae := S3_N*pi*sqr(S3_De)/4;
  dt := S3_Tu-S3_Tu1-S3_T1;
  trajectory;
  Te := Te - dt;
  f0 := f0 - S3_Fu*cos(pi*S3_au/180);
  m1 := m1 + S3_Mup/S3_Tu;
  dt := 1.0;
  time_traj;

  writeln(S3_Name,' Mainstage!');
  m0 := S3_Mp2;
  Me := Me - S3_Mp2;
  dF := 0;
  dRp := 0;
  Te := S3_Tu2 - S3_T1 - S3_T2;
  dt := 1.0;
  time_traj;

  writeln('Ullage motor jettison!');
  Me := Me - S3_Mus;
  dt := 1.0-frac(t0);
  trajectory;
  traj := orb;
  iorb := true;
  pow := 1.0;
  dt := 1.0;
  repeat
    trajectory
  until vi > via;
  dt := -dt;
  trajectory;
  dt := 0.1;
  repeat
    trajectory
  until vi > via;
  dt := -dt;
  trajectory;
  dt := 0.01;
  repeat
    trajectory
  until vi > via;

  writeln(S3_Name,' Engine Cutoff!');
  traj := air;
  fair := false;
  f0 := 0;
  m1 := 0;
  dt := 1.0;
  Te := S3_Ts;
  time_traj;

  maxa := maxa/f3maxa;
  h := (hp+ha)/2;
  dh := ha-h;
  writeln;
  writeln('Perigee = ',(hp/1000):5:1,' km, Apogee = ',(ha/1000):5:1,
          ' km, Average Altitude = ',(h/1000):5:1,plmic,(dh/1000):3:1,' km');
  writeln;
end;{stage 3}
