procedure stage1;
{Finds the trajectory of the boosters for the Space Launch System.
 Steven S. Pietrobon 21 Dec 1997. Revised 12 Oct 2013}
var ta,tb,tc,f0t1,f0t2,m1t1,m1t2,Fd,S1_A:double;

begin{stage 1}
  tfmax := 0;
  mfmax := S3_Mi + S3_Mup + S3_Mus + S3_Mp1 + S3_Mp2 + S3_Ms + LAS_M + SAJ_M +
          SC_M;
  Afmax := pi*sqr(S3_D)/4;
  fmax := gs*mfmax;
  ta := S1_D/2;
  tb := S1_Dn/2;
  tc := arctan(tb*sqrt(4*sqr(ta)-sqr(tb))/(2*sqr(ta)-sqr(tb)));
  S1_A := S1_Nn*(sqr(tb)*(tc+pi)/2 - sqr(ta)*tc + tb*ta);
  writeln('Addititional area = ',S1_A:5:3,' m',sqrc);
  Ar := S1_N*(pi*sqr(ta) + S1_A) + pi*sqr(S2_D)/4 + S2_A;
  Ae := S1_N*S1_Ne*pi*sqr(S1_De)/4 + S2_N*(S2_F-S2_Fs)/Psl;
  Fd := Ae*Psl;
  Me := S1_N*S1_Ms + S2_Mp2 + S2_Ms + mfmax;
  m0 := S1_N*S1_Mp + S2_Mp1;
  t0 := 0.0;
  x0 := 0.0;
  x1s := cos(inc*pi/180)*2*pi*Re/T;
  x1 := x1s;
  h0 := 0.0;
  h1 := 0.0;
  r0 := 0.0;
  p0 := 0.0;
  dRp := 0.0;
  dF := 0.0;
  dv := 0.0;
  f0t1 := S1_N*S1_Ne*S1_F;
  f0t2 := S2_N*S2_F*S2_R;
  f0 := f0t1 + f0t2;
  m1t1 := -f0t1/S1_V;
  m1t2 := -f0t2/S2_V;
  m1 := m1t1 + m1t2;
  flo := f0-Fd;
  mlo := Me+m0;
  alo := flo/mlo;
  writeln(t0:7:2,gs:6:1,round(x1s):6,round(h0):8,round(r0):10,
          90.0:7:2,0.0:7:2,90.0:7:2,0.0:9:1,mlo:10:1);

  dt := 1.0;
  dp := 0.0;
  traj := air;
  fair := true;
  hmax := h_turn;
  traj_height;
  dt := -dt/10;
  traj_height;
  dt := -dt/10;
  traj_height;

  writeln('Pitch over!');
  dp := angle1*pi/180;
  dt := 1.0;
  trajectory;
  dp := 0.0;
  Te := tt;
  time_traj;
  dp := -angle1*pi/180;
  dt := 1.0;
  trajectory;
  p0 := 0;

  writeln('End turn.');
  dp := 0.0;
  dt := 1.0-frac(t0);
  trajectory;
  dt := 1.0;
  Te := -S1_N*S1_Mp/m1t1 - t0 - S1_Tc/2;
  time_traj;

  writeln(S1_Name,' cutoff!');
  Te := S1_Tc;
  dRp := -m1t1/Te;
  dF := -f0t1/Te;
  dt := 1.0;
  time_traj;

  writeln(S1_Name,' seperation!');
end;{stage 1}
