{SLS Block IB constants. Steven S. Pietrobon  4 Mar 2016.
  1 Mar 2016 v1.00 First Release
  7 Mar 2016 v1.01 Five engine core
 19 May 2016 v1.02 MB-60 third stage
 20 May 2016 v1.03 Corrected stage 3 unusable propellant mass}

const Name = 'SLS Block IIB';
  {Stage 1 constants}
  S1_Name =   'Dark Knights';
  S1_Mp   =  680388.6; {kg, propellant mass}
  S1_Ms   =   96615.2; {kg, burnout mass}
  S1_N    =         2; {no. of boosters}
  S1_D    =    5.2883; {m,  aft-skirt diameter}
  S1_A    =    -0.038; {m^2, hold down posts and retrockets area less Core 
                            overlap area, 0.763 - 0.801 m^2}
  S1_De   =    3.8748; {m,  nozzle average diameter}
  S1_V    =    2756.6; {m/s, vacuum exhaust speed}
  S1_Ta   =     130.2; {s,  action time}
  S1_Td   = 0.986832971065; {s, incremental time}
 
  {Stage 2 constants}
  S2_Name =   'Core';
  S2_Mp1   =  960489; {kg, mainstage propellant mass used, 982663 kg total -
                           10546 kg startup - 7984 kg reserve - 2098 kg residual
                           - 1546 kg cutoff}
  S2_Mp2   =    1546; {kg, cut off propellant mass used}
  S2_Ms    =  122221; {kg, dry mass 112139 + 7984 kg reserve + 2098 kg residual}
  S2_D     =  8.4074; {m,  stage diameter}
  S2_A     =   2.073; {m^2, feed lines, engine fairings, and tunnel
                            2*0.608 + 4*0.203 + 0.045 m^2}
  S2_Ts    =    0.76; {s, separation time after MECO}

  {Stage 2 engine constants}
  S2_Eng_Name = 'RS-25E';
  S2_N     =       5; {no. of engines}
  S2_F     = 2090664; {N,   vacuum thrust}
  S2_Fs    = 1668298; {N,   sea level thrust}
  S2_V     =  4420.8; {m/s, vacuum exhaust speed}
  S2_I     =    0.01; {thrust incremental ratio}
  S2_R     =    1.11; {thrust ratio}

  {Stage 3 constants updated from simulation}
  S3_Mi    =    5368; {kg, interstage mass}
  S3_Mp    =  104086; {kg, mainstage propellant mass used, 107880 kg total -
                           2788 kg unusable - 797 kg reserve - 209 kg deorbit}
  S3_Ms    =   19465; {kg, cutoff mass, 15671 kg dry + 2788 kg unusable +
                           797 kg reserve + 209 kg deorbit}
  S3_U_Mp  =      71; {kg, ullage and RCS propellant}
  SC_M     =  136103; {kg, Spacecraft mass}

  {Other Stage 3 constants}
  S3_Name  = 'EUS';
  S3_T1    =     3.4; {s,  time to engine start}
  S3_T2    =     2.6; {s,  thrust build up time}
  S3_Ts    =     2.9; {s,  cutoff to seperation time}
  S3_D     =  8.4074; {m,  stage diameter}
  S3_Li    =    11.0; {m,  interstage length}
  S3_Vs    =    0.01; {delta-V reserve increase}

  {Stage 3 engine constants}
  S3_Eng_Name = 'MB-60';
  S3_N     =       4; {no. of engines}
  S3_F     =  266893; {N,   vacuum thrust}
  S3_V     =  4530.7; {m/s, vacuum exhaust speed}
  S3_De    =   2.286; {m,   nozzle exit diameter}
  S3_Me    =     590; {kg, engine mass}
  S3_MR    =     5.4; {oxidiser to fuel mixture ratio}

  {Stage 3 ullage engine constants}
  S3_U_N   =       4; {m/s, Number of ullage engines}
  S3_U_F   =    4003; {N,   Ullage thrust, R-40B}
  S3_U_V   =  2873.3; {m/s, Ullage exhaust speed, R-40B}
  S3_U_De  =   0.040; {m,   Ullage nozzle diameter, R-40B}
  S3_U_T   =     0.2; {s,   Ullage start time after Core separation}
  S3_U_Mp1 = (S3_T1+S3_T2-S3_U_T)*S3_U_N*S3_U_F/S3_U_V; {ullage propellant mass}
  S3_U_Vs  =     0.1; {delta-V reserve increase}

  {Spacecraft constants}
  PLF_T    =     330; {s,  time to PLF jettison from launch}
  PLF_M    =    9707; {kg, Payload Fairing mass}

  {Launch constants}
  inc      =   28.45; {deg, Kennedy Space Center inclination}
  inc_orb  =   28.45; {deg, Target inclination for TLI}
  h_turn   =     110; {m,   pitch over altitude}
  angle1   =    -1.5; {deg, pitch over angle rate for stage 1}
  amax1    =   29.42; {m/s^2, maximum acceleration strain}
  hamin    =  200000; {m,   minimum orbital altitude}
  hpmax    =   37000; {m,   maximum perigee altitude}

  {Stage 3 Reference values}
  Mi_r     =    7394; {kg, reference interstage mass}
  Li_r     =    15.0; {m,  reference interstage length}
  fmax_r   = 7989605; {N,  reference SP maximum force}
  S3_Mi_s = Mi_r*S3_Li/(fmax_r*Li_r); {interstage mass scale factor}

  S3_Me_r  =     301; {kg, reference RL-10C-2 engine mass}
  S3_Md_r  =   14515; {kg, reference stage 3 dry mass}
  S3_N_r   =       4; {reference number of engines}
  S3_Md = S3_Md_r+S3_N*S3_Me-S3_N_r*S3_Me_r; {Stage 3 dry mass}

  Ro_r     =  1053.9; {kg/s, reference oxidiser propellant rate}
  Rf_r     =   190.4; {kg/s, reference fuel propellant rate}
  Mbto_r   =     787; {kg, reference below tank oxidiser mass}
  Mbtf_r   =     123; {kg, reference below tank fuel mass}
  Mfb_r    =    1363; {kg, reference below tank fuel mass}
  Mbto_s = Mbto_r/Ro_r; {reference below tank oxidiser mass scale factor}
  Mbtf_s = Mbtf_r/Rf_r; {reference below tank fuel mass scale factor}
  Mfb_s  = Mfb_r/Rf_r; {reference fuel bial mass scale factor}
  S3_Mpu_r =    2524; {kg, reference unusable propellant}
  S3_F_r   =  110093; {N,  reference vacuum thrust}
  S3_V_r   =  4530.7; {m/s, reference vacuum exhaust speed}
  S3_MR_r  =    5.88; {reference mixture ratio}
  S3_Rp_r = S3_N_r*S3_F_r/S3_V_r; {kg/s, reference stage 3 propellant rate}
  S3_Ro_r = S3_Rp_r/(1+1/S3_MR_r); {kg/s, reference stage 3 oxidiser rate}
  S3_Rf_r = S3_Rp_r/(1+S3_MR_r); {kg/s, reference stage 3 fuel rate}
  S3_Mbto_r = round(Mbto_s*S3_Ro_r); {kg, reference stage 3 below tank oxidiser 
                                          mass}
  S3_Mbtf_r = round(Mbtf_s*S3_Rf_r); {kg, reference stage 3 below tank fuel 
                                          mass}
  S3_Mfb_r  = round(Mfb_s*S3_Rf_r); {kg, reference stage 3 fuel bias mass} 
  S3_Mbf_r  = S3_Mbto_r+S3_Mbtf_r+S3_Mfb_r; {kg, reference stage 3 below tank 
                                                 and fuel bias mass}
  S3_Rp = S3_N*S3_F/S3_V; {kg/s, reference stage 3 propellant rate}
  S3_Ro = S3_Rp/(1+1/S3_MR); {kg/s, reference stage 3 oxidiser rate}
  S3_Rf = S3_Rp/(1+S3_MR); {kg/s, reference stage 3 fuel rate}
  S3_Mbto = round(Mbto_s*S3_Ro); {kg, reference stage 3 below tank oxidiser 
                                          mass}
  S3_Mbtf = round(Mbtf_s*S3_Rf); {kg, reference stage 3 below tank fuel 
                                          mass}
  S3_Mfb  = round(Mfb_s*S3_Rf); {kg, reference stage 3 fuel bias mass} 
  S3_Mbf  = S3_Mbto+S3_Mbtf+S3_Mfb; {kg, reference stage 3 below tank 
                                                 and fuel bias mass}
  S3_Mpu = S3_Mpu_r + S3_Mbf - S3_Mbf_r;

var S3_Mt,S3_Mi_n,S3_Mp_n,SC_M_n,S3_Mpr:double;