procedure stage2;
{Finds the trajectory of the Core for the Space Launch System.
 Steven S. Pietrobon  1 Mar 2016}

begin{stage 2}
  writeqn('Maximum angle of attack (degrees)? ',maxa);
  if niter = 1 then
    maxa := maxa*pi/180;

  amax := amax1;
  Ar := Afmax[2];
  Ae := S2_N*(S2_F-S2_Fs)/Psl;
  f0 := S2_N*S2_F*S2_R;
  m1 := -f0/S2_V;
  Me := S2_Mp2 + S2_Ms + mfmax[3];
  dp := 0.0;
  dF := 0.0;
  dRp := 0.0;
  trajectory; {remaining time after booster separation}
  traj := orb;
  iorb := true;
  pow := 2.0;
  Te := PLF_T - t0;
  dt := 1.0;
  time_traj;

  writeln('PLF Jettison!');
  Me := Me - PLF_M;
  mfmax[3] := mfmax[3] - PLF_M;
  Te := -m0/m1;
  dt := 1.0;  
  time_traj;

  m0 := S2_Mp2;
  Me := Me - S2_Mp2;
  Te := 2*S2_V*m0/(S2_N*S2_F*S2_R);
  dF := -f0/Te;
  dRp := -dF/S2_V;
  dt := 1.0;
  traj := air;
  fair := false;
  time_traj;

  writeln(S2_Name,' Engine Cutoff!');
  Ae := 0;
  dF := 0;
  dRp := 0;
  dt := S2_Ts;
  trajectory;

  writeln(S2_Name,' Separation! Vacuum and zero gravity delta-V = ',dv:3:1,
          ' m/s');
  dvo := dv;
end;{stage 2}
