procedure stage3;
{Finds the trajectory of the Orbiter of the Space Shuttle.
 Steven S. Pietrobon 25 Dec 1997. Revised 10 Jan 2000}

var vo,m0r,S3_Mp_n,S3_Ms_n,SC_M_n,S3_Mpr_n,RCS_M_n,SP_M_n,S3_Md_n:double;
    S3_Mpt_n,dvi,S3_Mt,S3_Mi_n:double;
    cfile:text;
    to_orbit:boolean;
    ans:string;

begin{stage 3}
  if not(iterate) or (niter = 1)
     then begin{pause}
            write(question,'Transfer to apogee? ');
            readln(ans);
            to_orbit := (ans = 'y') or (ans = 'Y') or (ans = '');
          end{pause}
     else to_orbit := true;
  m0r := m0;

  dvo := dv;
  if to_orbit then
    begin{to orbit}
      Ar := Afmax[3];
      Ae := 0;
      m0 := S3_Mp;
      Me := mfmax[3] - S3_Mi - S3_Mp;
      f0 := 0.0;
      m1 := 0.0;
      p0 := 0.0;
      dt := 1.0;
      dp := 0.0;
      dF := 0.0;
      dRp := 0.0;
      traj := air;
      fair := true;
      while h0s*h0 < hamin do
        trajectory;
      dt := 0.1;
      while h0s*h0 < hamin do
        trajectory;
      dt := 0.01;
      while h0s*h0 < hamin do
        trajectory;

      h := (hp+ha)/2;
      dh := ha-h;
      writeln('Perigee = ',(hp/1000):5:1,' km, Apogee = ',(ha/1000):5:1,
          ' km, Average Altitude = ',(h/1000):5:1,plmic,(dh/1000):3:1,' km');

      writeln(S3_Eng_Name,' ignition!');
      traj := vac;
      Ae := S3_N*pi*sqr(S3_De)/4;
      f0 := S3_N*S3_F;
      m1 := -f0/S3_V;
      dt := 1.0;
      repeat
        trajectory;
        vo := sqrt(mu/(Re+h0));
      until vi > vo;
      dt := -1.0;
      trajectory;
      vo := sqrt(mu/(Re+h0));
      dt := -((m0+Me)/(1/(exp((vo-vi)/S3_V)-1)+1))/m1;
      trajectory;
    end;{to orbit}

  writeln(S3_Eng_Name,' cutoff!');
  dvi := dv-dvo;
  writeln('Vacuum and zero gravity delta-V = ',dvi:3:1,' m/s');
  dvo := dv;
  S3_Mi_n := round(S3_Mi_s*fmax[3]);
  SP_M_n := round(mfmax[3]+m0r-S3_Mi_n);
  RCS_M_n := round(RCS_M_s*SP_M_n);
  S3_Mp_n := round(S3_Mp-m0);
  if dvi = 0
    then S3_Mpr_n := 0
    else S3_Mpr_n := round((SP_M_n-S3_Mp_n-RCS_M_n)/
                           (1+1/(exp(dvi*S3_Vs/S3_V)-1)));
  S3_Mpt_n := S3_Mp_n+S3_Mpr_n+RCS_M_n+S3_Mpu;
  if S3_Mpt_n <= 0 then
    S3_Mpt_n := 1;
  S3_Md_n := round(S3_N*S3_Me+S3_Md_s*exp(S3_Md_p*ln(S3_Mpt_n)));
  S3_Ms_n := S3_Md_n+S3_Mpr_n+RCS_M_n+S3_Mpu;
  SC_M_n := SP_M_n - S3_Ms_n - S3_Mp_n;
  S3_Mt := SP_M_n + S3_Mi_n;

  h := (hp+ha)/2;
  dh := ha-h;
  writeln;
  writeln('Turn Time = ',tt:5:3,' s, Maximum angle of attack = ',
          maxa*180/pi:7:4,degc);
  writeln(S3_Name,' in Orbit! Remaining propellant = ',m0r:1:0,' kg.');
  writeln('Perigee = ',(hp/1000):5:1,' km, Apogee = ',(ha/1000):5:1,
          ' km, Average Altitude = ',(h/1000):5:1,plmic,(dh/1000):3:1,' km');

  writeln('Vacuum and zero gravity delta-V = ',dv:1:0,' m/s');
  writeln('Stage 3 Maximum force = ',fmax[3]:1:0,' N at ',tfmax[3]:4:2,' s');
  writeln('Liftoff thrust = ',flo:1:0,' N at ',alo:5:2,' m/s',sqrc,
          ' for ',mlo:1:0,' kg');
  if simout then
    begin{output parameters}
      writeln('Maximum dynamic pressure = ',Pqmax:1:0,' Pa at ',tPqmax:5:2,
              ' s');
      writeln('Maximum acceleration = ',a_max:5:2,' m/s',sqrc,' at ',ta_max:5:2,
              ' s');
    end;{output parameters}
  writeln('  S3_Mt   = ',S3_Mt:7:0,
          '; {kg, interstage and payload mass}');
  writeln('  SC_M    = ',SC_M_n:7:0,'; {kg, Spacecraft mass}');
  writeln;

  assign(cfile,'const_n.pas');
  rewrite(cfile);
  writeln(cfile,'  {Stage 3 constants updated from simulation}');
  writeln(cfile,'  S3_Mi    =    ',S3_Mi_n:4:0,'; {kg, adaptor mass}');
  writeln(cfile,'  S3_Mp    =  ',S3_Mp_n:6:0,'; {kg, propellant mass used, ',
                S3_Mpt_n:1:0,' kg total - ',S3_Mpr_n:1:0,' kg reserve -');
  writeln(cfile,'                           ',RCS_M_n:1:0,' kg RCS - ',
                S3_Mpu:1,' kg unusable}');
  writeln(cfile,'  S3_Ms    =   ',S3_Ms_n:5:0,'; {kg, cutoff mass, ',
                S3_Md_n:1:0,' kg dry + ',RCS_M_n:1:0,' kg RCS + ',
                S3_Mpr_n:1:0,' kg reserve');
  writeln(cfile,'                           + ',S3_Mpu:1,' kg unusable}');
  writeln(cfile,'  SC_M     =  ',SC_M_n:6:0,'; {kg, Spacecraft mass}');
  close(cfile);
end;{stage 3}
