procedure stage4;
{Finds the trajectory of the Orbiter of the Space Shuttle.
 Steven S. Pietrobon 25 Dec 1997. Revised 10 Jan 2000}
var S4_Mt,S4_Mp1_n,vo:double;
    cfile:text;

procedure tli;
var ans:string;
    time:double;
begin{TLI}
  write(question,'Go for TLI? ');
  readln(ans);
  if (ans = 'y') or (ans = 'Y') then
    begin{to orbit}
      writeln(S4_Name,' TLI Ignition!');
      m0 := 0;
      Me := Me-SC_M_LEO;
      Ar := Afmax[4];
      Te := S4_Te;
      dF := S4_N*S4_F/Te;
      dRp := -dF/S4_V;
      Ae := S4_N*pi*sqr(S4_De)/4;
      dt := 1.0;
      time_traj;

      writeln(S4_Name,' TLI Mainstage!');
      dF := 0;
      dRp := 0;
      traj := vac;
      pow := 1.0;
      dt := 1.0;
      repeat
        trajectory
      until 1.01*ha > hamax;
      dt := -1.0;
      trajectory;
      dt := 0.1;
      repeat
        trajectory
      until ha > hamax;
    end;{to orbit}
  time := pi*sqrt(sma*sma*sma/mu);
  Te := m0*S4_V/(S4_N*S4_F);
  writeln('You are on your way to the Moon!');
  write('Perigee = ',(hp/1000):5:1,' km, ');
  write('Apogee = ',(ha/1000):8:1,' km, ');
  writeln('Travel Time = ',time/(86400):4:2,' days.');
  writeln('TLI propellant mass = ',-m0:5:1,' kg');
  writeln('Vacuum and zero gravity delta-V = ',(dv-dvo):3:1,' m/s');
  dvo := dv;
end;{TLI}

begin{stage 4}
  Ar := Afmax[4];
  m0 := 0;
  Me := S4_Mp + S4_Ms + SC_M_n;
  S4_Mt := Me;
  dt := 1.0;
  Te := S4_T1;
  time_traj;

  writeln(S4_Name,' LEO Ignition!');
  m0 := m0 + S4_Mp;
  Me := Me - S4_Mp;
  Te := S4_Te;
  dF := S4_N*S4_F/Te;
  dRp := -dF/S4_V;
  Ae := S4_N*pi*sqr(S4_De)/4;
  dt := 1.0;
  time_traj;

  writeln(S4_Name,' LEO Main Stage!');
  dF := 0;
  dRp := 0;
  traj := orb;
  iorb := true;
  pow := 1.0;
  dt := 1.0;
  vo := sqrt(mu/(Re+hamin));
  repeat
    trajectory
  until vi > vo;
  dt := -dt;
  trajectory;
  dt := -(Me+m0)/(1/(exp((vo-vi)/S4_V)-1)+1)/m1;
  trajectory;

  writeln(S4_Name,' LEO Cutoff!');
  writeln('Vacuum and zero gravity delta-V = ',(dv-dvo):3:1,' m/s');
  dvo := dv;
  Ae := 0;
  f0 := 0;
  m1 := 0;
  dt := 1.0;
  Te := S3_Ts;
  traj := air;
  fair := false;
  time_traj;

  S4_Mp1_n := round(S4_Mp - m0);
  SC_M_n := S4_Mt - (S4_Mp1_n + S4_Ms);

  h := (hp+ha)/2;
  dh := ha-h;
  if h <> hold then
    begin{new max}
      maxanew := maxa - (h-hamin)*(maxa-maxaold)/(h-hold);
      hold := h;
      maxaold := maxa;
    end;{new max}

  writeln;
  writeln('Turn Time = ',tt:5:3,' s, Maximum angle of attack = ',
          maxa*180/pi:7:4,degc);
  writeln(S3_Name,' in Orbit! Remaining propellant = ',m0:1:0,' kg.');
  writeln('Perigee = ',(hp/1000):5:1,' km, Apogee = ',(ha/1000):5:1,
          ' km, Average Altitude = ',(h/1000):5:1,plmic,(dh/1000):3:1,' km');

  writeln('Vacuum and zero gravity delta-V = ',dv:1:0,' m/s');
  writeln('Stage 3 Maximum force = ',fmax[3]:1:0,' N at ',tfmax[3]:4:2,' s');
  writeln('Stage 4 Maximum force = ',fmax[4]:1:0,' N at ',tfmax[4]:4:2,' s');
  writeln('Liftoff thrust = ',flo:1:0,' N at ',alo:5:2,' m/s',sqrc,
          ' for ',mlo:1:0,' kg');
  if simout then
    begin{output parameters}
      writeln('Maximum dynamic pressure = ',Pqmax:1:0,' Pa at ',tPqmax:5:2,
              ' s');
      writeln('Maximum acceleration = ',a_max:5:2,' m/s',sqrc,' at ',ta_max:5:2,
              ' s');
    end;{output parameters}
  writeln('  S3_Mt   = ',S3_Mt:7:0,
          '; {kg, interstage, third stage and payload mass}');
  writeln('  S3_Mbto = ',S3_Mbto:7,'; {kg, oxidiser below tank mass}');
  writeln('  S3_Mbtf = ',S3_Mbtf:7,'; {kg, fuel below tank mass}');
  writeln('  S3_Mugo = ',S3_Mugo_n:7:0,'; {kg, oxidiser ullage gas mass}');
  writeln('  S3_Mugf = ',S3_Mugf_n:7:0,'; {kg, fuel ullage gas mass}');
  writeln('  S3_Vo   = ',S3_Vo:7:3,'; {kL, oxidiser volume}');
  writeln('  S3_Vf   = ',S3_Vf:7:3,'; {kL, fuel volume}');
  writeln('  S3_L    = ',S3_L:7:3,'; {m, tank wall length}');
  writeln('  S3_G    = ',S3_G:7:3,'; {m, shell cut length}');
  assign(cfile,'const_n.pas');
  rewrite(cfile);
  writeln(cfile);
  writeln(cfile,'  {Stage 3 constants updated from simulation}');
  writeln(cfile,'  S3_Mi    =    ',S3_Mi_n:4:0,'; {kg, interstage mass}');
  writeln(cfile,'  S3_Mp1   =     ',S3_Mp1:3,'; {kg, startup propellant mass}');
  writeln(cfile,'  S3_Mp2   =  ',S3_Mp2_n:6:0,
                '; {kg, mainstage propellant mass used, ',S3_Mp_n:6:0,
                ' kg total -');
  writeln(cfile,'                           ',S3_Mp1:3,' kg startup - ',
                S3_Mpr_n:1:0,' kg reserve - ',S3_Mbt:1,' kg below tank');
  writeln(cfile,'                           - ',S3_Mfb:1,' kg fuel bias - ',
                S3_Mug_n:1:0,' kg ullage gas}');
  writeln(cfile,'  S3_Ms    =   ',S3_Ms_n:5:0,'; {kg, cutoff mass, ',
                S3_Md_n:5:0,' kg dry + ',S3_Mru_n:4:0,' kg reserve/unusable}');
  writeln(cfile,'  S3_Mup   =     ',S3_Mup_n:3:0,
                '; {kg, total ullage motor propellant}');
  writeln(cfile,'  S3_Mus   =     ',S3_Mus_n:3:0,
                '; {kg, total ullage motor empty}');
  writeln(cfile,'  S3_Fu    =  ',S3_Fu_n:6:0,
                '; {N,  total ullage motor vacuum thrust}');
  writeln(cfile);
  writeln(cfile,'  {Stage 4 constants updated from simulation}');
  writeln(cfile,'  S4_Mi    =    ',S4_Mi_n:4:0,'; {kg, interstage mass}');
  writeln(cfile,'  S4_Mp    =    ',S4_Mp1_n:4:0,
                '; {kg, propellant mass used, 0 kg total - 0 kg reserve');
  writeln(cfile,'                           - 0 kg RCS}');
  writeln(cfile,'  S4_Ms    =       0',
                '; {kg, cutoff mass, 0 kg RCS propellant + 0 kg dry +');
  writeln(cfile,'                           0 kg reserve}');
  writeln(cfile,'  SC_M     =  ',SC_M_n:6:0,'; {kg, Spacecraft mass}');
  close(cfile);
  writeln('  SC_M    = ',SC_M_n:7:0,'; {kg, Spacecraft mass}');
  writeln;
  writeln('Recommended maxa = ',(maxanew*180/pi):7:4,degc);
  writeln;
  tli;
end;{stage 4}
