procedure stage3;
{Finds the trajectory of the Upper Stage for the Space Launch System.
 Steven S. Pietrobon 23 Dec 1997. Revised 30 Dec 1997, 20 Jul 2013, 19 Oct 2013,
 11 Sep 2015}

var S3_T2,via,mpi,dvi:double;

function shell(D,H,V:double):double;
{Uses Newton's method to solve shell equation}

const epsilon = 1e-6;
var G,Gold:double;

function f(G:double):double;
begin{f}
  f := 0.5*pi*sqr(D)*(2*H/3 + G*(sqr(G/H)/3-1));
end;{f}

function fp(G:double):double;
begin{fp}
  fp := 0.5*pi*sqr(D)*(sqr(G/H)-1);
end;{fp}

begin{shell}
  G := 0;
  repeat
    Gold := G;
    G := Gold -(f(Gold)-V)/fp(Gold);
  until abs(G-Gold) < epsilon;
  shell := G;
end;{shell}

procedure do_mpi;
begin{find mpi}
  mpi := mpi + (S3_Mp2+Me-mpi)*(1-exp((dvi-dv)*S3_Vs/S3_V));
  dvi := dv;
end;{find mpi}

begin{stage 3}
  Ar := Afmax[3];
  Ae := 0;
  m0 := 0;
  Me := mfmax[3] - S3_Mi;
  dp := 0.0;
  dF := 0.0;
  dRp := 0.0;
  Te := S3_T1;
  dt := 1.0;
  traj := air;
  fair := false;
  time_traj;

  writeln(S3_Name,' Ignition!');
  m0 := m0 + S3_Mp1;
  Me := Me - S3_Mp1;
  Te := 2*S3_V*S3_Mp1/(S3_N*S3_F);
  S3_T2 := Te;
  dF := S3_N*S3_F/Te;
  dRp := -dF/S3_V;
  Ae := S3_N*pi*sqr(S3_De)/4;
  dt := S3_Tu-S3_Tu1-S3_T1;
  trajectory;
  Te := Te - dt;
  f0 := f0 - S3_Fu*cos(pi*S3_au/180);
  m1 := m1 + S3_Mup/S3_Tu;
  dt := 1.0;
  time_traj;

  writeln(S3_Name,' Mainstage!');
  m0 := S3_Mp2;
  Me := Me - S3_Mp2;
  mpi := 0;
  dvi := dv;
  dF := 0;
  dRp := 0;
  Te := S3_Tu2 - S3_T1 - S3_T2;
  dt := 1.0;
  time_traj;

  writeln('Ullage motor jettison!');
  Me := Me - S3_Mus;
  do_mpi;
  dt := 1.0-frac(t0);
  trajectory;
  traj := orb;
  iorb := true;
  pow := 1.0;
  Te := S3_T_SMF - t0;
  dt := 1.0;
  time_traj;

  writeln('SMF Jettison!');
  Me := Me - SMF_M;
  do_mpi;
  Te := S3_T_LAS - S3_T_SMF;
  dt := 1.0;
  time_traj;

  writeln('LAS Jettison!');
  Me := Me - LAS_M;
  do_mpi;
  dt := 1.0;
  via := sqrt(2*mu/((Re+hamin)*((Re+hamin)/(Re+hpmax)+1)));
  repeat
    trajectory
  until vi > via;
  dt := -dt;
  trajectory;
  dt := -(Me+m0)/(1/(exp((via-vi)/S3_V)-1)+1)/m1;
  trajectory;

  writeln(S3_Name,' Engine Cutoff!');
  do_mpi;
  traj := air;
  fair := false;
  Ae := 0;
  f0 := 0;
  m1 := 0;
  dt := 1.0;
  Te := S3_Ts;
  time_traj;

  h := (hp+ha)/2;
  dh := ha-h;
  writeln(S3_Name,' Separation!');
  writeln('Perigee = ',(hp/1000):5:1,' km, Apogee = ',(ha/1000):5:1,
          ' km, Average Altitude = ',(h/1000):5:1,plmic,(dh/1000):3:1,' km');
  writeln('Vacuum and zero gravity delta-V = ',(dv-dvo):3:1,' m/s');
  writeln;
  dvo := dv;

  S3_Mt := mfmax[3];
  S3_Mi_n := round(S3_Mi_s*fmax[3]);
  S3_SP_M_n := S3_Mt-S3_Mi_n;
  S3_Fu_n := round(S3_Fu_s*exp(S3_Fu_p*ln(S3_SP_M_n)));
  S3_Mup_n := round(S3_Mup_s*S3_Fu_n);
  S3_Mus_n := round(S3_Mus_s*exp(S3_Mus_p*ln(S3_Mup_n)));

  S3_Mp_n := S3_Mp1+S3_Mp2-m0;
  S3_Mpr_n := round(mpi-S3_Mp2+m0);
  S3_Mp_n := S3_Mp_n+S3_Mpr_n;
  S3_Mugo_n := round(S3_Mugo_s*S3_Mp_n/(1+1/S3_MR));
  S3_Mugf_n := round(S3_Mugf_s*(S3_Mp_n/(1+S3_MR)+S3_Mfb));
  S3_Mug_n := S3_Mugo_n+S3_Mugf_n;
  S3_Mru_n := S3_Mpr_n+S3_Mbt+S3_Mfb+S3_Mug_n;
  S3_Mp_n := S3_Mp_n+S3_Mbt+S3_Mfb+S3_Mug_n;

  S3_Md_n := round(S3_N*S3_Me+S3_Md_s*exp(S3_Md_p*ln(S3_Mp_n)));
  S3_Mp2_n := S3_Mp_n-S3_Mp1-S3_Mru_n;
  S3_Ms_n := S3_Md_n+S3_Mru_n;
  S4_Mi_n := round(S4_Mi_s*fmax[4]);
  SC_M_n := S3_Mt-(S3_Mi_n+SMF_M+LAS_M+S3_Mup_n+S3_Mus_n+S3_Mp1+S3_Mp2_n+
                   S3_Ms_n+S4_Mi_n+S4_Mp+S4_Ms);

  S3_Mpu := S3_Mp1+S3_Mp2_n+S3_Mpr_n;
  S3_Vo := S3_ful*(S3_Mpu/(1+1/S3_MR)+S3_Mugo_n)/S3_do;
  S3_Vf := S3_ful*(S3_Mpu/(1+S3_MR)+S3_Mugf_n+S3_Mfb)/S3_df;
  S3_L := 4*((S3_Vo+S3_Vf)/(pi*sqr(S3_D))-S3_D/9);
  S3_G := shell(S3_D,S3_D/3,S3_Vo);
end;{stage 3}
