{SLS Block II constants. Steven S. Pietrobon 21 Dec 1997.
 Revised  7 Feb 1998, 15 Sep 2012, 20 July 2013
 14 Sep 2013 v1.04 Added second stage optimisation
 24 Aug 2014 v1.05 Updated RSRMV, Core and J-2X parameters
  6 Sep 2014 v1.06 Corrected third stage reference reserve propellant mass
 11 Jun 2015 v1.07 Updated SMF and LAS masses and times
 10 Jul 2015 v1.08 Updated SLA mass}

const Name =    'SLS';
  {Stage 1 constants}
  S1_Name =   'RSRMV';
  S1_Mp   =    632489; {kg, usable propellant mass}
  S1_Ms   =     96751; {kg, burnout mass}
  S1_N    =         2; {no. of boosters}
  S1_D    =    5.2883; {m,  aft-skirt diameter}
  S1_A    =    -0.038; {m^2, hold down posts and retrockets area less Core 
                            overlap area, 0.763 - 0.801 m^2}
  S1_De   =    3.8748; {m,  nozzle exit diameter}
  S1_V    =    2605.4; {m/s, vacuum exhaust speed}
  S1_Ta   =     128.4; {s,  action time}
 
  {Stage 2 constants}
  S2_Name =   'Core';
  S2_Mp1   =  957652; {kg, mainstage propellant mass used, 982663 kg total -
                           12656 kg startup - 7984 kg reserve - 2517 kg residual
                           - 1854 kg cutoff}
  S2_Mp2   =    1854; {kg, cut off propellant mass used}
  S2_Ms    =  133596; {kg, dry mass 123595 + 7984 kg reserve + 2517 kg residual}
  S2_D     =   8.407; {m,  stage diameter}
  S2_A     =   3.087; {m^2, feed lines, engine fairings, and tunnel
                            3*0.608 + 6*0.203 + 0.045 m^2}
  S2_Ts    =    0.76; {s, separation time after MECO}

  {Stage 2 engine constants}
  S2_Eng_Name = 'RS-25E';
  S2_N     =       6; {no. of engines}
  S2_F     = 2090664; {N,   vacuum thrust}
  S2_Fs    = 1668298; {N,   sea level thrust}
  S2_V     =  4420.8; {m/s, vacuum exhaust speed}
  S2_I     =    0.01; {thrust incremental ratio}
  S2_R     =    1.11; {thrust ratio}

  {Stage 3 constants updated from simulation}
  S3_Mi    =    4624; {kg, interstage mass}
  S3_Mp1   =     771; {kg, startup propellant mass}
  S3_Mp2   =  166048; {kg, mainstage propellant mass used, 169426 kg total -
                           771 kg startup - 449 kg reserve - 435 kg below tank
                           - 656 kg fuel bias - 1067 kg ullage gas}
  S3_Ms    =   19501; {kg, cutoff mass, 16894 kg dry + 2607 kg reserve/unusable}
  S3_Mup   =     205; {kg, total ullage motor propellant}
  S3_Mus   =     191; {kg, total ullage motor empty}
  S3_Fu    =  115425; {N,  total ullage motor vacuum thrust}

  {Stage 4 constants updated from simulation}
  S4_Mi    =    1738; {kg, interstage mass}
  S4_Mp    =    1528; {kg, propellant mass used, 0 kg total - 0 kg reserve
                           - 0 kg RCS}
  S4_Ms    =       0; {kg, cutoff mass, 0 kg RCS propellant + 0 kg dry +
                           0 kg reserve}
  SC_M     =  140667; {kg, Spacecraft mass}

  {Other Stage 3 constants}
  S3_Name  = 'Upper Stage';
  S3_T_SMF =     375; {s,  time to SMF jettison from launch}
  S3_T_LAS =     380; {s,  time to LAS jettison from launch}
  S3_T1    =     3.4; {s,  time to engine start}
  S3_Ts    =     2.9; {s,  cutoff to seperation time}
  S3_D     =   8.407; {m,  stage diameter}
  S3_au    =      30; {degrees, ullage motor offset angle}
  S3_Tu    =    3.87; {s,  ullage motor burn time}
  S3_Tu1   =    0.18; {s,  ullage motor burn time before Core separation}
  S3_Tu2   =   11.72; {s,  ullage motor separation after Core separation}
  S3_Li    =     7.5; {m,  interstage length}
  S3_do    =    1149; {kg/kL, oxidiser density}
  S3_df    =    70.9; {kg/kL, fuel density}
  S3_ful   =    1.07; {ullage volume increase}

  {Stage 3 engine constants}
  S3_Eng_Name = 'J-2X';
  S3_N     =       2; {no. of engines}
  S3_F     = 1307777; {N,   vacuum thrust}
  S3_V     =  4393.4; {m/s, vacuum exhaust speed, full nozzle}
  S3_De    =   3.048; {m,   nozzle exit diameter}
  S3_Me    =    2472; {kg,  engine mass}
  S3_MR    =     5.5; {oxidiser to fuel mixture ratio}
  S3_Vs    =   1.005; {delta-V reserve increase}

  {Other Stage 4 constants}
  S4_Name  =   'CPS';
  S4_T1    =     1.8; {s,  time to engine start}
  S4_D     =   8.407; {m,  stage diameter}
  S4_Li    =     6.3; {m,  interstage length}

  {Stage 4 engine constants}
  S4_Eng_Name = 'RL10C-2';
  S4_N     =       4; {no. of engines}
  S4_De    =  2.1463; {m,   nozzle diameter}
  S4_F     =  110093; {N,   vacuum thrust}
  S4_V     =  4535.6; {m/s, vacuum exhaust speed}
  S4_Me    =     301; {kg,  engine mass}
  S4_Te    =     0.3; {s,   startup transient time}
  S4_RCS_V =  3432.3; {m/s, RCS exhaust speed}

  {Spacecraft constants}
  SMF_M    =    1384; {kg, Service Module Fairing mass}
  LAS_M    =    7643; {kg, Launch Abort System mass}
  SLA_M    =    1285; {kg, Spacecraft Launch Adaptor mass}
  SMA_M    =     510; {kg, Service Module Adaptor mass}
  LEO_Mb   =      24; {kg, Low Earth Orbit boiloff}
  TAD_Mp   =       6; {kg, Translation and Docking Propellant mass}
  SC_M_LEO = SLA_M + SMA_M + LEO_Mb + TAD_Mp;

  {Launch constants}
  inc      =   28.45; {deg, Kennedy Space Center inclination}
  inc_orb  =   32.55; {deg, Target inclination for TLI}
  h_turn   =     110; {m,   pitch over altitude}
  angle1   =    -0.8; {deg, pitch over angle rate for stage 1}
  amax1    =   29.42; {m/s^2, maximum acceleration strain}
  hamin    =  200000; {m,   minimum orbital altitude}
  hpmax    =   37000; {m,   maximum perigee altitude}
  hamax  = 400242535; {m,   Lunar apogee altitude}

  {Stage 3 Reference values}
  Mi_r     =    7394; {kg, reference interstage mass}
  Li_r     =    15.0; {m,  reference interstage length}
  fmax_r   = 7989605; {N,  reference SP maximum force}
  S3_Mi_s = Mi_r*S3_Li/(fmax_r*Li_r); {interstage mass scale factor}
  S4_Mi_s = Mi_r*S4_Li/(fmax_r*Li_r);

  SIVB_M   =  166258; {kg, S-IVB mass}
  SIVB_Mup =    53.5; {kg, S-IVB solid motor ullage propellant mass}
  SIVB_Mus =    61.2; {kg, S-IVB solid motor ullage dry mass}
  SIVB_Fu  =   30159; {N,  S-IVB total ullage motor vacuum thrust for 2 motors}
  SII_M    =  666299; {kg, S-II mass}
  SII_Fu   =  409236; {kg, S-II total ullage motor vacuum thrust for 4 motors}  
  S3_Fu_p = ln(SIVB_Fu/SII_Fu)/ln(SIVB_M/SII_M); {ullage motor thrust power 
                                                 factor}
  S3_Fu_s = SIVB_Fu/exp(S3_Fu_p*ln(SIVB_M)); {ullage motor thrust scale factor}
  S3_Mup_s = SIVB_Mup/SIVB_Fu; {ullage motor propellant mass scale factor}
  S3_Mus_p = 0.848; {ullage motor dry mass power factor}
  S3_Mus_s = SIVB_Mus/exp(S3_Mus_p*ln(SIVB_Mup)); {ullage motor propellant mass 
                                                   scale factor}

  S3_Mp_r =  452352; {kg, reference third stage propellant mass}
  S3_Md_r =   35402; {kg, reference third stage dry mass, includes engines}
  S3_Me_r =    1584; {kg, reference J-2 third stage engine mass}
  S3_N_r  =       5; {kg, reference number of engines}
  S3_Md_p =   0.848; {third stage dry mass power factor}
  S3_Md_s = (S3_Md_r-S3_N_r*S3_Me_r)/exp(S3_Md_p*ln(S3_Mp_r)); 
                     {third stage dry mass scale factor}
  S3_Mps  = S3_N*385.5; {kg, third stage startup propellant mass}

  S3_Ro_r   =   1053.9; {kg/s, S-II reference oxidiser rate}
  S3_Rf_r   =    190.4; {kg/s, S-II reference fuel rate}
  S3_Mito_r =      679; {kg, reference LOX In Tank at Separation}
  S3_Mbto_r =      787; {kg, reference LOX Below Tank at Separation}
  S3_Mugo_r =     2254; {kg, reference LOX ullage gas}
  S3_Mpo_r  =   379876; {kg, total LOX at liftoff} 
  S3_Mitf_r =     1505; {kg, reference Fuel In Tank at Separation}
  S3_Mbtf_r =      123; {kg, reference Fuel Below Tank at Separation}
  S3_Mugf_r =      599; {kg, reference fuel ullage gas}
  S3_Mpf_r  =    72476; {kg, total Fuel at liftoff} 
  S3_MR_r   =      4.8; {reference oxidiser to fuel mixture ratio}
  S3_Rf = S3_N*S3_F/(S3_V*(1+S3_MR));
                        {kg/s, fuel mass rate}
  S3_Mbto = round(S3_Mbto_r*S3_Rf*S3_MR/S3_Ro_r);
                        {kg, below tank oxidiser}
  S3_Mbtf = round(S3_Mbtf_r*S3_Rf/S3_Rf_r);
                        {kg, below tank fuel}
  S3_Mbt = S3_Mbto+S3_Mbtf;
                        {kg, below tank propellant}
  S3_Mfb_r  = S3_Mitf_r-S3_Mito_r/S3_MR_r;
                        {kg, reference fuel bias}
  S3_Mfb = round(S3_Mfb_r*S3_Rf/S3_Rf_r); 
                        {kg, fuel bias propellant}
  S3_Mugo_s = S3_Mugo_r/(S3_Mpo_r-S3_Mbto_r-S3_Mugo_r);
  S3_Mugf_s = S3_Mugf_r/(S3_Mpf_r-S3_Mbtf_r-S3_Mugf_r);

  {Boeing IAC 2012, derived from In-Space Stage}
  S4_Mp_r =   57300; {kg, reference propellant mass}
  S4_Md_r =    7600; {kg, reference dry mass, includes engines}
  S4_Me_r =     301; {kg, reference engine mass}
  S4_N_r  =       2; {kg, reference number of engines}
  S4_Md_p =   0.848; {third stage dry mass power factor}
  S4_Md_s = (S4_Md_r-S4_N_r*S4_Me_r)/exp(S4_Md_p*ln(S4_Mp_r));
                     {fourth stage dry mass scale factor}
  S4_Mpr_r =   1300; {kg, reference fourth stage reserve propellant mass}
  S4_Mpr_s = S4_Mpr_r/(S4_Mp_r-S4_Mpr_r);
                     {fourth stage reserve propellant mass scale factor}

var S3_Mt,S3_Mi_n,S3_SP_M_n,S3_Mp_n,S3_Mpr_n,S3_Mp2_n,S3_Ms_n,S3_Md_n:double;
    S3_Mup_n,S3_Mus_n,S3_Fu_n,SC_M_n,S4_Mi_n,S3_Mugo_n,S3_Mugf_n:double;
    S3_Mug_n,S3_Mru_n,S3_L,S3_Vo,S3_Vf,S3_Mpu,S3_G:double;
