procedure stage3;
{Finds the trajectory of the Upper Stage for the Space Launch System.
 Steven S. Pietrobon 23 Dec 1997. Revised 30 Dec 1997, 20 Jul 2013}

var vo,S3_T2:double;
    S3_Mt,S3_Mi_n,SP_M_n,RCS_M_n,S3_Fu_n,S3_Mup_n,S3_Mus_n:double;
    S3_Mp_n,S3_Mpr_n,S3_Md_n,S3_Mp2_n,S3_Ms_n,SC_M_n:double;

begin{stage 3}
  {writeqn('Maximum angle of attack (degrees)? ',maxa);
  maxa := maxa*pi/180;}

  Ar := pi*sqr(S3_D)/4;
  Ae := 0;
  Me := S3_Mus + S3_Mp1 + S3_Mp2 + S3_Ms + SC_M + SAJ_M + LAS_M;
  dp := 0.0;
  dF := 0.0;
  dRp := 0.0;
  Te := S3_T1;
  dt := 1.0;
  traj := air;
  fair := false;
  time_traj;

  writeln(S3_Name,' Ignition!');
  m0 := m0 + S3_Mp1;
  Me := Me - S3_Mp1;
  Te := 2*S3_V*S3_Mp1/(S3_N*S3_F);
  S3_T2 := Te;
  dF := S3_N*S3_F/Te;
  dRp := -dF/S3_V;
  Ae := S3_N*pi*sqr(S3_De)/4;
  dt := S3_Tu-S3_Tu1-S3_T1;
  trajectory;
  Te := Te - dt;
  f0 := f0 - S3_Fu*cos(pi*S3_au/180);
  m1 := m1 + S3_Mup/S3_Tu;
  dt := 1.0;
  time_traj;

  writeln(S3_Name,' Mainstage!');
  m0 := S3_Mp2;
  Me := Me - S3_Mp2;
  dF := 0;
  dRp := 0;
  Te := S3_Tu2 - S3_T1 - S3_T2;
  dt := 1.0;
  time_traj;

  writeln('Ullage motor jettison!');
  Me := Me - S3_Mus;
  dt := 1.0-frac(t0);
  trajectory;
  vo := sqrt(mu/(Re+hpmin));
  traj := orb;
  iorb := true;
  pow := 1.0;
  Te := S3_Tj - t0;
  dt := 1.0;
  time_traj;

  writeln('SAJ and LAS Jettison!');
  Me := Me - SAJ_M - LAS_M;
  dt := 1.0;
  repeat
    trajectory
  until vi > vo;
  dt := -dt;
  trajectory;
  dt := -(Me+m0)/(1/(exp((vo-vi)/S3_V)-1)+1)/m1;
  trajectory;

  writeln(S3_Name,' Engine Cutoff!');
  traj := vac;
  f0 := 0;
  m1 := 0;
  dt := 1.0;
  Te := S3_Ts;
  time_traj;

  h := (hp+ha)/2;
  dh := ha-h;
  if h <> hold then
    begin{new max}
      maxanew := maxa - (h-hpmin)*(maxa-maxaold)/(h-hold);
      hold := h;
      maxaold := maxa;
    end;{new max}

  writeln;
  writeln('Turn Time = ',tt:5:3,' s, Maximum angle of attack = ',
          maxa*180/pi:7:4,degc);
  writeln(S3_Name,' in Orbit! Remaining propellant = ',m0:1:0,' kg.');
  writeln('Perigee = ',(hp/1000):5:1,' km, Apogee = ',(ha/1000):5:1,
          ' km, Average Altitude = ',(h/1000):5:1,plmic,(dh/1000):3:1,' km');
  writeln('Vacuum and zero gravity delta-V = ',dv:1:0,' m/s');
  writeln('Maximum force = ',fmax:1:0,' N at ',tfmax:4:2,' s');
  writeln('Liftoff thrust = ',flo:1:0,' N at ',alo:5:2,' m/s',sqrc,
          ' for ',mlo:1:0,' kg');
  if simout then
    begin{output parameters}
      writeln('Maximum dynamic pressure = ',Pqmax:1:0,' N at ',tPqmax:5:2,' s');
      writeln('Maximum acceleration = ',a_max:5:2,' m/s',sqrc,' at ',ta_max:5:2,
              ' s');
    end;{output parameters}
  writeln;

  S3_Mt := S3_Mi+S3_Mup+S3_Mus+S3_Mp1+S3_Mp2+S3_Ms+SC_M;
  writeln('  S3_Mt    =  ',S3_Mt:6:0,
          '; {kg, interstage, third stage and payload mass}');
  S3_Mi_n := round(S3_Mi_s*fmax);
  writeln('  S3_Mi    =   ',S3_Mi_n:5:0,'; {kg, interstage mass}');
  writeln('  S3_Mp1   =     ',S3_Mp1:3,'; {kg, startup propellant mass}');
  SP_M_n := S3_Mt-S3_Mi_n;
  RCS_M_n := round(RCS_M_s*SP_M_n);
  S3_Fu_n := round(S3_Fu_s*exp(S3_Fu_p*ln(SP_M_n)));
  S3_Mup_n := round(S3_Mup_s*S3_Fu_n);
  S3_Mus_n := round(S3_Mus_s*exp(S3_Mus_p*ln(S3_Mup_n)));

  S3_Mp_n := S3_Mp1+S3_Mp2-m0;
  S3_Mpr_n := round(S3_Mpr_s*S3_Mp_n);
  S3_Mp_n := S3_Mp_n+S3_Mpr_n;
  S3_Md_n := round(S3_N*S3_Me+S3_Md_s*exp(S3_Md_p*ln(S3_Mp_n)));
  S3_Mp2_n := S3_Mp_n-S3_Mp1-S3_Mpr_n;
  writeln('  S3_Mp2   =  ',S3_Mp2_n:6:0,
          '; {kg, mainstage propellant mass used, ',S3_Mp_n:6:0,' kg total -');
  writeln('                           ',S3_Mp1:3,' kg startup - ',
          S3_Mpr_n:3:0,' kg reserve}');
  S3_Ms_n := RCS_M_n+S3_Md_n+S3_Mpr_n;
  writeln('  S3_Ms    =   ',S3_Ms_n:5:0,'; {kg, cutoff mass, ',RCS_M_n:3:0,
          ' kg RCS propellant + ',S3_Md_n:5:0,' kg dry +');
  writeln('                           ',S3_Mpr_n:4:0,' kg reserve}');
  writeln('  S3_Mup   =     ',S3_Mup_n:3:0,
          '; {kg, total ullage motor propellant}');
  writeln('  S3_Mus   =     ',S3_Mus_n:3:0,'; {kg, total ullage motor empty}');
  writeln('  S3_Fu    =  ',S3_Fu_n:6:0,
          '; {N,  total ullage motor vacuum thrust}');
  SC_M_n := S3_Mt-(S3_Mi_n+S3_Mup_n+S3_Mus_n+S3_Mp1+S3_Mp2_n+S3_Ms_n);
  writeln('  SC_M     =  ',SC_M_n:6:0,'; {kg, Spacecraft mass}');
  writeln;
  writeln('Recommended maxa = ',(maxanew*180/pi):7:4,degc);
  writeln;
end;{stage 3}
