procedure stage2;
{Finds the trajectory of the Core for the Space Launch System.
 Steven S. Pietrobon 23 Dec 1997. Revised 30 Dec 1997, 20 Jul 2013, 19 Oct 2013}

begin{stage 2}
  writeqn('Maximum angle of attack (degrees)? ',maxa);
  maxa := maxa*pi/180;

  amax := amax1;
  Ar := pi*sqr(S2_D)/4 + S2_A;
  Ae := S2_N*(S2_F-S2_Fs)/Psl;
  f0 := S2_N*S2_F*S2_R;
  m1 := -f0/S2_V;
  Me := S2_Mp2 + S2_Ms + mfmax;
  dp := 0.0;
  dF := 0.0;
  dRp := 0.0;
  trajectory; {remaining time after booster separation}
  traj := orb;
  iorb := true;
  pow := 2.0;
  Te := S2_Tj - t0;
  dt := 1.0;
  time_traj;

  writeln('SAJ and LAS Jettison!');
  Me := Me - SAJ_M - LAS_M;
  mfmax := mfmax - SAJ_M - LAS_M;
  dt := 1.0;  
  Te := -m0/m1;
  time_traj;

  m0 := S2_Mp2;
  Me := Me - S2_Mp2;
  Te := 2*S2_V*m0/(S2_N*S2_F*S2_R);
  dF := -f0/Te;
  dRp := -dF/S2_V;
  dt := 1.0;
  traj := air;
  fair := false;
  time_traj;

  writeln(S2_Name,' Engine Cutoff!');
  Ae := 0;
  dF := 0;
  dRp := 0;
  dt := S2_Ts - S3_Tu1;
  trajectory;
  f0 := f0 + S3_Fu*cos(pi*S3_au/180);
  m0 := S3_Mup;
  Me := Me - S3_Mup;
  m1 := m1 - S3_Mup/S3_Tu;
  dt := S3_Tu1;
  trajectory;

  writeln(S2_Name,' Separation! Vacuum and zero gravity delta-V = ',dv:1:0,
          ' m/s');
end;{stage 2}
