procedure stage2;
{Finds the trajectory of the Core for the Space Launch System.
 Steven S. Pietrobon 23 Dec 1997. Revised 30 Dec 1997, 20 Jul 2013, 19 Oct 2013}

var dtt,dFt,dRpt,Rd,tem:double;
    I:integer;

begin{stage 2}
  writeqn('Maximum angle of attack (degrees)? ',maxa);
  maxa := maxa*pi/180;

  amax := amax1;
  Ar := pi*sqr(S2_D)/4 + S2_A;
  Ae := S2_N*(S2_F-S2_Fs)/Psl;
  f0 := S2_N*S2_F*S2_R;
  m1 := -f0/S2_V;
  Me := S2_Mp2 + S2_Ms + mfmax;
  dp := 0.0;
  dF := 0.0;
  dRp := 0.0;
  trajectory; {remaining time after booster separation}

  Te := (f0/amax1 - m0 - Me)/m1;
  dt := 1.0;
  time_traj;

  writeln('Maximum acceleration reached!');
  traj := orb;
  iorb := true;
  pow := 2.0;
  dtt := S2_Tt*S2_I;
  dFt := -S2_N*S2_F/S2_Tt;
  dRpt := -dFt/S2_V;
  Rd := S2_R;
  repeat
    dt := dtt;
    dF := dFt;
    dRp := dRpt;
    trajectory;
    Rd := Rd - S2_I;
    dt := 1.0;
    dF := 0.0;
    dRp := 0.0;
    Te := (f0/amax1 - m0 - Me)/m1;
    time_traj;
  until Rd < S2_Rc+epsilon;

  I := 1;
  repeat
    writeln('Engine ',I:1,' cutoff!');
    dt := S2_Tc;
    dF := -S2_F*S2_Rc/dt;
    dRp := -dF/S2_V;
    trajectory;
    Ae := Ae - (S2_F-S2_Fs)/Psl;
    dt := 1.0;
    dF := 0.0;
    dRp := 0.0;
    Te := (f0/amax1 - m0 - Me)/m1;
    tem := (exp(m1*(via-vi)/f0)-1)*(m0+Me)/m1;
    if Te < tem 
      then time_traj
      else begin{maxv}
             repeat
               trajectory
             until vi > via;
             dt := -dt;
             trajectory;
             dt := (exp(m1*(via-vi)/f0)-1)*(m0+Me)/m1;
             trajectory;
           end;{maxv}
    I := I+1;
  until (I > S2_N) or (tem < Te);

  writeln(S2_Name,' Engine Cutoff!');
  traj := air;
  fair := false;
  f0 := 0;
  m1 := 0;
  dt := 1.0;
  Te := S3_Ts;
  time_traj;

  h := (hp+ha)/2;
  dh := ha-h;
  writeln(S2_Name,' separation!');
  writeln('Perigee = ',(hp/1000):5:1,' km, Apogee = ',(ha/1000):5:1,
          ' km, Average Altitude = ',(h/1000):5:1,plmic,(dh/1000):3:1,' km'); 
  writeln;
end;{stage 2}
