{SLS Block 1C constants. Steven S. Pietrobon 21 Dec 1997.
 Revised  7 Feb 1998, 15 Sep 2012, 20 July 2013
 14 Sep 2013 Added second stage optimisation
 19 Oct 2013}

const Name = 'SLS';

  {Stage 1 constants}
  S1_Name =   'RSRMV';
  S1_Mp   =  633233.1; {kg, propellant mass}
  S1_Ms   =  100543.3; {kg, burnout mass}
  S1_N    =         2; {no. of boosters}
  S1_D    =    5.1562; {m,  aft-skirt diameter}
  S1_De   =    3.8748; {m,  nozzle average diameter}
  S1_V    =    2622.3; {m/s, vacuum exhaust speed}
  S1_Ta   =     131.9; {s,  action time}
 
  {Stage 2 constants}
  S2_Name =   'Core';
  S2_Mp1   =  964825; {kg, mainstage propellant mass used, 983388 kg total -
                           7439 kg startup - 8210 kg reserve - 1678 kg residual
                           - 1236 kg cutoff}
  S2_Mp2   =    1236; {kg, cut off propellant mass used}
  S2_Ms    =  125463; {kg, dry mass 115575 + 8210 kg reserve + 1678 kg residual}
  S2_D     =  8.4074; {m,  stage diameter}
  S2_A     =   0.235; {m^2, LOX feed line, sqr(D)*(1+pi/4)/2}
  S2_Ts    =    0.76; {s, separation time after MECO}
  S2_Tj    =     330; {s,  time to LAS jettison}

  {Stage 2 engine constants}
  S2_Eng_Name = 'RS-25D';
  S2_N     =       4; {no. of engines}
  S2_F     = 2090664; {N,   vacuum thrust}
  S2_Fs    = 1668083; {N,   sea level thrust}
  S2_V     =  4436.5; {m/s, vacuum exhaust speed}
  S2_I     =    0.01; {thrust incremental ratio}
  S2_R     =    1.09; {thrust ratio}
  S2_Rc    =    0.65; {cutoff thrust ratio}
  S2_Tc   =      6.7; {s, time before start of MECO}
  S2_Tt    =      10; {s, cutoff throttle down time for 100% thrust change}

  {Stage 3 constants}
  S3_Name  = 'Skylab 5';
  {Constants below updated with simulation}
  S3_Ts    =     5.0; {s,  cutoff to seperation time}
  S3_D     =  8.4074; {m,  stage diameter}
  S3_Mi    =    5346; {kg, interstage mass}
  S3_Mp    =    1524; {kg, propellant mass used, 1626 kg total - 80 kg reserve
                           - 22 kg RCS}
  S3_Ms    =     837; {kg, cutoff mass, 22 kg RCS propellant + 735 kg dry +
                           80 kg reserve}
  SC_M     =   50510; {kg, Spacecraft mass}

  {Stage 3 engine constants}
  S3_Eng_Name = 'AJ10-190';
  S3_N     =       1; {no. of engines}
  S3_De    =   1.168; {m,   nozzle diameter}
  S3_F     =   26689; {N,   vacuum thrust}
  S3_V     =  3071.4; {m/s, vacuum exhaust speed}
  S3_Me    =     135; {kg,  engine mass}
  S3_Mpr_f =    0.05; {reserve propellant mass proportion}

  {Launch constants}
  inc      =   28.45; {deg, Kennedy Space Center inclination}
  inc_orb  =   51.60; {deg, International Space Station inclination}
  h_turn   =     110; {m,   pitch over altitude}
  angle1   =    -0.7; {deg, pitch over angle rate for stage 1}
  amax1    =   25.00; {m/s^2, maximum acceleration strain}
  hpmin    =  400000; {m,   minimum orbital altitude}
  epsilon  = 0.00001; {a very small non-zero number}
  via      =  7890.9; {m/s, pre-transfer speed}

  {Reference parameters}
  S3_Mp_r =    5415; {kg, reference third stage propellant mass}
  S3_Md_r =    1800; {kg, reference third stage dry mass, includes engines}
  S3_Me_r =     135; {kg, reference third stage engine mass}
  S3_N_r  =       1; {kg, reference number of engines}
  S3_Md_p =   0.848; {third stage dry mass power factor}
  S3_Md_s = (S3_Md_r-S3_N_r*S3_Me_r)/exp(S3_Md_p*ln(S3_Mp_r)); {third stage dry 
                                                             mass scale factor}
  S3_M_r   =  237501; {kg, reference third stage mass}
  SC_M_r   =   96910; {kg, reference spacecraft mass}
  SP_M_r = S3_M_r+SC_M_r; {reference stage and payload mass}
  RCS_M_r  =     136; {kg, reference RCS propellant mass}
  RCS_M_s = RCS_M_r/SP_M_r; {RCS mass scale factor}

