{SLS Block 1C constants. Steven S. Pietrobon 21 Dec 1997.
 Revised  7 Feb 1998, 15 Sep 2012, 20 July 2013}
const {Stage 0 constants}
  {$DEFINE makefiles}

  Name    =     'SLS';

  {Stage 1 constants}
  S1_Name =   'RSRMV';
  S1_Mp   =  633233.1; {kg, propellant mass}
  S1_Ms   =  100543.3; {kg, burnout mass}
  S1_N    =         2; {no. of boosters}
  S1_D    =    5.1562; {m,  aft-skirt diameter}
  S1_De   =    3.8748; {m,  nozzle average diameter}
  S1_V    =    2622.3; {m/s, vacuum exhaust speed}
  S1_Ta   =     131.9; {s,  action time}
 
  {Stage 2 constants}
  S2_Name =   'Core';
  S2_Mp1   =  964825; {kg, mainstage propellant mass used, 983388 kg total -
                           7439 kg startup - 8210 kg reserve - 1678 kg residual
                           - 1236 kg cutoff }
  S2_Mp2   =    1236; {kg, cut off propellant mass used}
  S2_Ms    =  125463; {kg, dry mass 115575 + 8210 kg reserve + 1678 kg residual}
  S2_D     =  8.4074; {m,  stage diameter}
  S2_A     =   0.235; {m^2, LOX feed line, sqr(D)*(1+pi/4)/2}
  S2_Ts    =    0.76; {s, separation time after MECO}
  S2_T1    =      33; {s, change thrust to F1}
  S2_T2    =     125; {s, change thrust to F2}
  S2_Tt1   =      10; {s, thrust bucket throttle down time for 100% change}
  S2_Tt2   =      15; {s, thrust bucket throttle up time for 100% change}
  S2_R0    =    1.10; {thrust ratio at T0}
  S2_R1    =    0.65; {thrust ratio at T1}
  S2_R2    =    1.10; {thrust ratio at T2}
  S2_Tj    =     330; {s,  time to LAS jettison}

  {Stage 2 engine constants}
  S2_Eng_Name = 'RS-25D';
  S2_N     =       4; {no. of engines}
  S2_F     = 2090664; {N,   vacuum thrust}
  S2_Fs    = 1668083; {N,   sea level thrust}
  S2_V     =  4436.5; {m/s, vacuum exhaust speed}
  S2_I     =    0.01; {thrust incremental ratio}

  {Stage 3 constants}
  S3_Name  = 'Upper Stage';
  S3_Mi    =    7394; {kg, interstage mass}
  S3_Mp1   =     771; {kg, startup propellant mass}
  S3_Mp2   =  206430; {kg, mainstage propellant mass used, 210966 kg total -
                           771 kg startup - 3765 kg reserve}
  S3_Ms    =   30300; {kg, cutoff mass, 136 kg RCS propellant + 26399 kg dry +
                           3765 kg reserve}
  S3_N     =       2; {no. of engines}
  S3_T1    =     3.4; {s,  time to engine start}
  S3_Ts    =     5.0; {s,  cutoff to seperation time}
  S3_D     =  8.4074; {m,  stage diameter}

  {Stage 3 engine constants}
  S3_Eng_Name = 'J-2X';
  S3_F     = 1281088; {N,   vacuum thrust}
  S3_V     =  4275.7; {m/s, vacuum exhaust speed}
  S3_De    =   3.048; {m,   nozzle exit diameter}

  {Spacecraft constants}
  LAS_M    =    7394; {kg, Launch Abort System mass}
  SAJ_M    =     920; {kg, Jettisoned adaptor mass}
  SC_M     =   72138; {kg, Spacecraft mass}

  {Launch constants}
  inc      =   28.45; {deg, Kennedy Space Center inclination}
  h_turn   =     110; {m,   pitch over altitude}
  angle1   =    -0.1; {deg, pitch over angle rate for stage 1}
  amax1    =   29.42; {m/s^2, maximum acceleration strain}
  hpmin    =  200000; {m,   minimum orbital altitude}