procedure stage3;
{Finds the trajectory of the Upper Stage for the Space Launch System.
 Steven S. Pietrobon 23 Dec 1997. Revised 30 Dec 1997, 20 Jul 2013, 20 Oct 2013}

var vo:double;

begin{stage 3}
  {writeqn('Maximum angle of attack (degrees)? ',maxa);
  maxa := maxa*pi/180;}

  Ar := pi*sqr(S3_D)/4;
  Ae := S3_N*pi*sqr(S3_De)/4;
  Me := S3_Mp1 + S3_Mp2 + S3_Ms + SC_M;
  m0 := 0;
  m1 := 0;
  f0 := 0;
  dp := 0.0;
  dF := 0.0;
  dRp := 0.0;
  Te := S3_T1;
  dt := 1.0;
  traj := air;
  fair := false;
  time_traj;

  writeln(S3_Name,' Ignition!');
  m0 := S3_Mp1;
  Me := Me - m0;
  Te := 2*S3_V*m0/(S3_N*S3_F);
  dF := S3_N*S3_F/Te;
  dRp := -dF/S3_V;
  Ae := S3_N*pi*sqr(S3_De)/4;
  dt := 1.0;
  time_traj;

  writeln('Mainstage!');
  m0 := S3_Mp2;
  Me := Me - m0;
  dF := 0;
  dRp := 0;
  dt := 1.0;
  vo := sqrt(mu/(Re+hpmin));
  traj := orb;
  iorb := true;
  pow := 1.0;
  repeat
    trajectory
  until 1.01*vi > vo;

  traj := vac;
  dt := 0.1;
  repeat
    trajectory;
    vo := sqrt(mu/(Re+h0));
  until 1.001*vi > vo;

  dt := 0.01;
  repeat
    trajectory;
    vo := sqrt(mu/(Re+h0));
  until vi > vo;

  writeln(S3_Name,' Engine Cutoff!');
  f0 := 0;
  m1 := 0;
  dt := 1.0;
  Te := S3_Ts;
  time_traj;

  writeln;
  writeln('Turn Time = ',tt:5:3,' s, Maximum angle of attack = ',
          maxa*180/pi:7:4,degc);
  writeln(S3_Name,' in Orbit! Remaining propellant = ',m0:1:0,' kg.');
  writeln('Perigee = ',(hp/1000):5:1,' km, Apogee = ',(ha/1000):5:1,
          ' km, Average Altitude = ',(hp+ha)/2000:5:1,' km');
  writeln('Vacuum and zero gravity delta-V = ',dv:1:0,' m/s');
  writeln('Maximum force on ',S2_Name,' = ',fmax:1:0,' N at ',tfmax:4:2,' s');
  writeln('Liftoff thrust = ',flo:1:0,' N at ',alo:5:2,' m/s',sqrc,
          ' for ',mlo:1:0,' kg');
  if simout then
    begin{output parameters}
      writeln('Maximum dynamic pressure = ',Pqmax:1:0,' N at ',tPqmax:5:2,' s');
      writeln('Maximum acceleration = ',a_max:5:2,' m/s',sqrc,' at ',ta_max:5:2,
              ' s');
    end;{output parameters}
  writeln;
end;{stage 3}
