procedure stage1;
{Finds the trajectory of the boosters for the Space Launch System.
 Steven S. Pietrobon 21 Dec 1997. Revised  9 Feb 1998, 20 Jul 2013, 20 Oct 2013}
var ta,tb,tc,tl,Fl,tn,Fn,dFt,dRpt,m0p,Fd:double;
    s1:text;

procedure read_s1;
{Read booster. Steven S. Pietrobon 22 Dec 1997.}
begin{read s1}
  tl := tn;
  Fl := Fn;
  readln(s1,tn,Fn);
  dt := tn - tl;
  if dt > 1.0 then
    writeln('Error! Booster time increments must be at most 1 second');
  dF := S1_N*(Fn - Fl)/dt;
  dRp := -dF/S1_V + dRpt;
  dF := dF + dFt;
  m0p := m0p + 0.5*(Fl+Fn)*dt/S1_V;
end;{read s1}

procedure traj_time_s1;
{Booster burn for Te seconds. Steven S. Pietrobon 22 Dec 1997.
 Output dt is remaining time in S1 burn increment.}
begin{traj time s1}
  read_s1;
  Te := Te-dt;
  while Te > 0 do
    begin{traj}
      trajectory;
      read_s1;
      Te := Te-dt;
    end;{traj}
  ta := dt;
  dt := Te+dt;
  trajectory;
  dt := ta-dt;
end;{traj time s1}

begin{stage 1}
  assign(s1,'s1.dat');
  reset(s1);

  tfmax := 0;
  mfmax := S3_Mi + S3_Mp1 + S3_Mp2 + S3_Ms + LAS_M + SAJ_M + SC_M;
  Afmax := pi*sqr(S3_D)/4;
  fmax := gs*mfmax;
  Ar := pi*(S1_N*sqr(S1_D) + sqr(S2_D))/4 + S2_A;
  Ae := S1_N*pi*sqr(S1_De)/4 + S2_N*(S2_F-S2_Fs)/Psl;
  Fd := Ae*Psl;
  Me := S1_N*S1_Ms + S2_Mp2 + S2_Ms + mfmax;
  m0 := S1_N*S1_Mp + S2_Mp1;
  mlo := Me+m0;
  t0 := 0.0;
  x0 := 0.0;
  x1s := cos(inc*pi/180)*2*pi*Re/T;
  x1 := x1s;
  h0 := 0.0;
  h1 := 0.0;
  r0 := 0.0;
  p0 := 0.0;
  dRp := 0.0;
  dF := 0.0;
  dv := 0.0;
  f0 := S2_N*S2_F*S2_R;
  m1 := -f0/S2_V;
  writeln(t0:7:2,gs:6:1,round(x1s):6,round(h0):8,round(r0):10,
          90.0:7:2,0.0:7:2,90.0:7:2,0.0:9:1,m0+Me:10:1);

  readln(s1,tn,Fn);
  dt := tn;
  dF := S1_N*Fn/dt;
  dFt := 0.0;
  dRp := -dF/S1_V;
  dRpt := 0.0;
  m0p := 0.5*Fn*dt/S1_V;
  ta := -gs*dRp/2;
  tb := -gs*m1 + dF;
  tc := f0 - Fd - gs*(m0 + Me);
  t0 := (-tb + sqrt(tb*tb - 4*ta*tc))/(2*ta);
  m0 := m0 + t0*m1 + t0*t0*dRp/2;
  f0 := f0 + t0*dF;
  m1 := m1 + t0*dRp;
  writeln(t0:7:2,(f0-Fd)/(m0+Me):6:1,round(x1s):6,round(h0):8,round(r0):10,
          90.0:7:2,0.0:7:2,90.0:7:2,0.0:9:1,m0+Me:10:1);

  dt := dt - t0;
  dp := 0.0;
  traj := air;
  fair := true;
  trajectory;

  flo := f0-Fd;
  alo := flo/(m0+Me);
  repeat
    read_s1;
    trajectory;
  until h0 > h_turn;
  dt := -dt;
  trajectory;
  Te := -dt;
  dt := -dt/10;
  hmax := h_turn;
  traj_height;
  dt := -dt/10;
  traj_height;

  writeln('Pitch over!');
  dp := angle1*pi/180;
  dt := Te;
  trajectory;
  Te := 1.0-dt;
  read_s1;
  dt := Te;
  trajectory;
  dp := 0.0;
  dt := 1.0-dt;
  trajectory;
  Te := tt-dt;
  traj_time_s1;
  dp := -angle1*pi/180;
  trajectory;
  Te := 1.0-dt;
  read_s1;
  dt := Te;
  trajectory;
  p0 := 0;

  writeln('End turn.');
  dp := 0.0;
  dt := 1-dt;
  trajectory;
  Te := S1_Ta - t0;
  traj_time_s1;
  m0p := m0p - dt*(Fn-0.5*dt*(Fn-Fl)/(tn-tl))/S1_V;
  m0p := S1_Mp - m0p;
  m0 := m0 - S1_N*m0p;

  writeln('Booster seperation! Residual booster propellant = ',m0p:1:0,' kg.');
  close(s1);
end;{stage 1}
