procedure stage2;
{Finds the trajectory of the Core for the Space Launch System.
 Steven S. Pietrobon  1 Mar 2016}

var dtt,dFt,dRpt,Rd,tem,ht:double;
    I:integer;
    do_maxa:boolean;

function via:double;
begin{via}
  via := sqrt(mu*(2/(Re+h0)-1/(Re+(hamin+hp)/2)));
end;{via}

begin{stage 2}
  writeqn('Maximum angle of attack (degrees)? ',maxa);
  if niter = 1 then
    maxa := maxa*pi/180;

  amax := amax1;
  Ar := Afmax[2];
  Ae := S2_N*(S2_F-S2_Fs)/Psl;
  f0 := S2_N*S2_F*S2_R;
  m1 := -f0/S2_V;
  Me := S2_Mp2 + S2_Ms + mfmax[3];
  dp := 0.0;
  dF := 0.0;
  dRp := 0.0;
  traj := orb;
  iorb := true;
  pow := 2.0;
  trajectory; {remaining time after booster separation}
  Te := PLF_T - t0;
  dt := 1.0;
  time_traj;

  writeln('PLF Jettison!');
  Me := Me - PLF_M;
  mfmax[3] := mfmax[3] - PLF_M;
  Te := (f0/amax1 - m0 - Me)/m1;
  dt := 1.0;
  while (Te > dt) and (alpha > 0.00175) do
    begin{increment time}
      trajectory;
      Te := Te-dt
    end;{increment time}
  traj := vac;
  iorb := true;
  time_traj;

  writeln('Maximum acceleration reached!');
  dtt := S2_Tt*S2_I;
  dFt := -S2_N*S2_F/S2_Tt;
  dRpt := -dFt/S2_V;
  Rd := S2_R;
  do_maxa := true;
  repeat
    dt := dtt;
    dF := dFt;
    dRp := dRpt;
    trajectory;
    Rd := Rd - S2_I;
    dt := 1.0;
    dF := 0.0;
    dRp := 0.0;
    Te := (f0/amax1 - m0 - Me)/m1;
    while (Te > dt) and (ha < hamin) do
      begin{continue}
        trajectory;
        Te := Te-dt;
      end{continue};
    if ha < hamin
      then begin{finish max}
             dt := Te;
             tem := (exp(m1*(via()-vi)/f0)-1)*(m0+Me)/m1;
             if tem < dt
               then begin{end burn}
                      dt := tem;
                      repeat
                        trajectory;
                        dt := (exp(m1*(via()-vi)/f0)-1)*(m0+Me)/m1;
                      until dt < epsilon;
                      do_maxa := false;
                    end{end burn}
               else trajectory;
           end{finish max}
      else begin{max height}
             dt := (exp(m1*(via()-vi)/f0)-1)*(m0+Me)/m1;
             repeat
               trajectory;
               dt := (exp(m1*(via()-vi)/f0)-1)*(m0+Me)/m1;
             until abs(dt) < epsilon;
             do_maxa := false;
           end;{max height}
  until (Rd < S2_Rc+epsilon) or not(do_maxa);

  if do_maxa then
    begin{cut engines}
      I := 1;
      repeat
        writeln('Engine ',I:1,' cutoff!');
        Te := S2_Tc;
        dF := -S2_F*S2_Rc/Te;
        dRp := -dF/S2_V;
        dt := 1.0;
        time_traj;
        Ae := Ae - (S2_F-S2_Fs)/Psl;
        dt := 1.0;
        dF := 0.0;
        dRp := 0.0;
        Te := (f0/amax1 - m0 - Me)/m1;
        tem := (exp(m1*(via()-vi)/f0)-1)*(m0+Me)/m1;
        if Te < tem
          then time_traj
          else begin{maxv}
                 repeat
                   trajectory
                 until vi > via();
                 dt := -dt;
                 trajectory;
                 dt := (exp(m1*(via()-vi)/f0)-1)*(m0+Me)/m1;
                 trajectory;
               end;{maxv}
        I := I+1;
      until (I > S2_N) or (tem < Te);
    end;{cut engines}

  writeln(S2_Name,' Engine Cutoff!');
  traj := air;
  fair := false;
  f0 := 0;
  m1 := 0;
  dt := S2_Ts;
  trajectory;

  writeln(S2_Name,' Separation! Vacuum and zero gravity delta-V = ',dv:3:1,
          ' m/s');
  if h1 < 0
    then ht := hpd
    else ht := hpa;
  if hp <> hold
    then begin{adjust}
           maxanew := tt - (hp-ht)*(tt-tto)/(hp-hold);
           if (maxanew > 0) and (maxanew < 90)
             then begin{valid}
                    hold := hp;
                    tto := tt;
                    tt := maxanew;
                  end{valid}
             else begin{increment}
                    if hp > ht
                      then tt := tt - 0.1
                      else tt := tt + 0.1;
                    hold := 0;
                    tto := 0;
                  end;{increment}
         end{adjust}
    else begin{increment}
           if hp > ht
             then tt := tt - 0.1
             else tt := tt + 0.1;
           hold := 0;
           tto := 0;
         end;{increment}

  h := (hp+ha)/2;
  dh := ha-h;
  writeln('Perigee = ',hp/1000:5:1,' km, Apogee = ',ha/1000:5:1,
          ' km, Average Altitude = ',h/1000:5:1,plmic,dh/1000:3:1,' km'); 
  writeln;
  writeln('Recommended tt = ',tt:7:4,' s');
  {writeln('Recommended maxa = ',maxa*180/pi:7:4,degc);}
{writeln('tto = ',tto:7:4,' s');
writeln('tt = ',tt:7:4,' s');
writeln('hpo = ',hold/1000:5:1,' km');
writeln('hp = ',hp/1000:5:1,' km');
writeln('ht = ',ht/1000:5:1,' km');
readln;}
  writeln;
end;{stage 2}
