program sls1b(input,output);
{Rocket simulation program written by Steven S. Pietrobon  21 Dec 1995.
 Revised 29 Dec 1997, 20 Jul 2013
  8 Sep 2013 Added S3 ullage motors
 23 Sep 2013 Changed RS-25 thrust to 109%, LAS separation to +330 s and
             RSRMV values to Boeing IAC 2012 paper, Optimised upper stage
 28 Sep 2013 Added RS-25 engine to core
 29 Sep 2013 Added sixth RS-25 engine to core
 19 Oct 2013 Corrected interstage mass calculation
  1 Jul 2015 Many updates performed and improvements made
  7 Mar 2015 Added iterate option
 18 May 2016 Modified from sls2b4o1. Changed boosters to RSRMV.}

{$I earth.pas}
{$I const.pas}
{$I rocket.pas}
{$I stage1.pas}
{$I stage2.pas}
{$I stage3.pas}

begin{main}
  init;
  repeat
    writeqn('Turn time (s)? ',tt);
    if tt >= 1
      then begin{lift off}
             repeat
               if niter = 1 then
                 begin{init angles}
                   tto := 0;
                   hold := 0;
                 end;{init angles}
               stage1;
               stage2;
               if iterate then
                 begin{iterate}
                   niter := niter+1;
                   iterate := (niter < maxiter) and (tt > 0) and (tt < 90)
                              and (abs(tt-tto) > 0.00005);
                 end;{iterate}
             until not(iterate);
             stage3;
             iterate := do_iterate;
             niter := 1;
           end{lift off}
      else if tt >= 0
             then writeln('Error! Turn time must be greater than one second.')
             else continue := false;
  until not(continue);
  close_sim;
end.{main}
