{SLS Block IB constants. Steven S. Pietrobon  4 Mar 2016.
  1 Mar 2016 v1.00 First Release Block IIB.
 18 May 2016 v1.01 No upper stage.
 18 May 2016 v1.02 Changed boosters to RSRMV.}

const Name = 'SLS Block IB';
  {Stage 1 constants}
  S1_Name =   'RSRMV';
  S1_Mp   =    632489; {kg, usable propellant mass}
  S1_Ms   =     96751; {kg, burnout mass}
  S1_N    =         2; {no. of boosters}
  S1_D    =    5.2883; {m,  aft-skirt diameter}
  S1_A    =    -0.038; {m^2, hold down posts and retrockets area less Core 
                            overlap area, 0.763 - 0.801 m^2}
  S1_De   =    3.8748; {m,  nozzle exit diameter}
  S1_V    =    2605.4; {m/s, vacuum exhaust speed}
  S1_Ta   =     128.4; {s,  action time}
  S1_Td   =       1.0; {s, incremental time}
 
  {Stage 2 constants}
  S2_Name =   'Core';
  S2_Mp1   =  963328; {kg, mainstage propellant mass used, 982663 kg total -
                           8437 kg startup - 7984 kg reserve - 1678 kg residual
                           - 1236 kg cutoff}
  S2_Mp2   =    1236; {kg, cut off propellant mass used}
  S2_Ms    =  110344; {kg, dry mass 100682 + 7984 kg reserve + 1678 kg residual}
  S2_D     =  8.4074; {m,  stage diameter}
  S2_A     =   2.073; {m^2, feed lines, engine fairings, and tunnel
                            2*0.608 + 4*0.203 + 0.045 m^2}
  S2_Ts    =    0.76; {s, separation time after MECO}

  {Stage 2 engine constants}
  S2_Eng_Name = 'RS-25E';
  S2_N     =       4; {no. of engines}
  S2_F     = 2090664; {N,   vacuum thrust}
  S2_Fs    = 1668298; {N,   sea level thrust}
  S2_V     =  4420.8; {m/s, vacuum exhaust speed}
  S2_I     =    0.01; {thrust incremental ratio}
  S2_R     =    1.11; {thrust ratio}
  S2_Rc    =    0.65; {cutoff thrust ratio}
  S2_Tc   =      6.7; {s, time before start of MECO}
  S2_Tt    =      10; {s, cutoff throttle down time for 100% thrust change}

  {Stage 3 constants updated from simulation}
  S3_Mi    =     971; {kg, adaptor mass}
  S3_Mp    =    2701; {kg, propellant mass used, 2783 kg total - 27 kg reserve -
                           32 kg RCS - 23 kg unusable}
  S3_Ms    =    1164; {kg, cutoff mass, 1082 kg dry + 32 kg RCS + 27 kg reserve
                           + 23 kg unusable}
  SC_M     =   75376; {kg, Spacecraft mass}

  {Other Stage 3 constants}
  S3_Name  = 'Skylab 5';
  S3_D     =  8.4074; {m,  stage diameter}
  S3_Li    =     5.0; {m,  adaptor length}
  S3_Mpu   =      23; {kg, unusable propellant}
  S3_Vs    =    0.01; {delta-V reserve increase}

  {Stage 3 engine constants}
  S3_Eng_Name = 'AJ10-190';
  S3_N     =       1; {no. of engines}
  S3_De    =   1.168; {m,   nozzle diameter}
  S3_F     =   26689; {N,   vacuum thrust}
  S3_V     =  3071.4; {m/s, vacuum exhaust speed}
  S3_Me    =     135; {kg,  engine mass}

  {Spacecraft constants}
  PLF_T    =     330; {s,  time to PLF jettison from launch}
  PLF_M    =    9707; {kg, Payload Fairing mass}

  {Launch constants}
  inc      =   28.45; {deg, Kennedy Space Center inclination}
  inc_orb  =   51.60; {deg, Target inclination for TLI}
  h_turn   =     110; {m,   pitch over altitude}
  angle1   =    -0.7; {deg, pitch over angle rate for stage 1}
  amax1    =   39.23; {m/s^2, maximum acceleration strain}
  hpa      =   37000; {m,   minimum perigee altitude if ascending}
  hpd      =  155000; {m,   minimum perigee altitude if descending}
  hamin    =  399000; {m,   minimum orbital altitude}
  h0s      =  1.0073; {m,   apogee burn starts at hamin/h0s}
  epsilon  = 0.00001; {a very small non-zero number}

  {Stage 3 Reference values}
  Mi_r     =    7394; {kg, reference interstage mass}
  Li_r     =    15.0; {m,  reference interstage length}
  fmax_r   = 7989605; {N,  reference SP maximum force}
  S3_Mi_s = Mi_r*S3_Li/(fmax_r*Li_r); {interstage mass scale factor}

  S3_Mp_r =    5415; {kg, reference third stage propellant mass}
  S3_Md_r =    1800; {kg, reference third stage dry mass, includes engines}
  S3_Me_r =     135; {kg, reference third stage engine mass}
  S3_N_r  =       1; {kg, reference number of engines}
  S3_Md_p =   0.848; {third stage dry mass power factor}
  S3_Md_s = (S3_Md_r-S3_N_r*S3_Me_r)/exp(S3_Md_p*ln(S3_Mp_r)); {third stage dry 
                                                             mass scale factor}
  S3_M_r   =  237501; {kg, reference third stage mass}
  SC_M_r   =   96910; {kg, reference spacecraft mass}
  SP_M_r = S3_M_r+SC_M_r; {reference stage and payload mass}
  RCS_M_r  =     136; {kg, reference RCS propellant mass}
  RCS_M_s = RCS_M_r/SP_M_r; {RCS mass scale factor}