procedure stage3;
{Finds the trajectory of the Upper Stage for the Space Launch System.
 Steven S. Pietrobon  1 Mar 2016}

const Ra = Re+hamin;
      Rp = Re+hpmax;
      Vdo = sqrt(mu/Ra) - sqrt(2*mu/(Ra*(Ra/Rp+1)));

var vo,dvi,S3_Ms_n,S3_U_Mp_n,S3_Mpdo,S3_Mpt:double;
    cfile:text;

begin{stage 3}
  Ar := Afmax[3];
  Ae := 0;
  m0 := 0;
  Me := mfmax[3] - S3_Mi;
  dp := 0.0;
  dF := 0.0;
  dRp := 0.0;
  dt := S3_U_T;
  traj := air;
  fair := false;
  trajectory;

  Ae := S3_U_N*pi*sqr(S3_U_De)/4;
  m0 := m0 + S3_U_Mp1;
  Me := Me - S3_U_Mp1;
  f0 := S3_U_N*S3_U_F;
  m1 := -f0/S3_U_V;
  Te := S3_T1-S3_U_T;
  dt := 1.0;
  time_traj;

  writeln(S3_Name,' Ignition!');
  Ae := Ae + S3_N*pi*sqr(S3_De)/4;
  m0 := m0 + S3_Mp;
  Me := Me - S3_Mp;
  dF := S3_N*S3_F/S3_T2;
  dRp := -dF/S3_V;
  Te := S3_T2;
  dt := 1.0;
  time_traj;

  writeln(S3_Name,' Mainstage!');
  dF := 0.0;
  dRp := 0.0;
  Ae := S3_N*pi*sqr(S3_De)/4;
  f0 := S3_N*S3_F;
  m1 := -f0/S3_V;
  dt := 1.0-frac(t0);
  trajectory;
  traj := orb;
  iorb := true;
  pow := 1.0;
  vo := sqrt(mu/(Re+hamin));
  dt := 1.0;
  repeat
    trajectory;
  until vi > vo;
  dt := -dt;
  trajectory;
  dt := -(Me+m0)/(1/(exp((vo-vi)/S3_V)-1)+1)/m1;
  trajectory;

  writeln(S3_Name,' Engine Cutoff!');
  traj := vac;
  Ae := 0;
  f0 := 0;
  m1 := 0;
  dt := 1.0;
  Te := S3_Ts;
  time_traj;

  writeln(S3_Name,' Separation!');
  dvi := dv-dvo;
  writeln('Vacuum and zero gravity delta-V = ',dvi:3:1,' m/s');
  dvo := dv;

  S3_Mt := mfmax[3] + PLF_M;
  S3_Mi_n := round(S3_Mi_s*fmax[3]);
  S3_Mp_n := round(S3_Mp-m0);
  S3_Mpr := round((Me+m0)/(1+1/(exp(dvi*S3_Vs/S3_V)-1)));
  S3_Ms_n := S3_Md+S3_Mpu+S3_Mpr;
  S3_U_Mp_n := round(2*S3_U_Mp1*(1+S3_U_Vs));
  S3_Mpdo := round(S3_Ms_n*(exp(Vdo/S3_V)-1));
  S3_Mpr := S3_Mpr + round(S3_Vs*S3_Mpdo);
  S3_Ms_n := S3_Md+S3_Mpu+S3_Mpr+S3_Mpdo;
  S3_Mpt := S3_Mpu + S3_Mp_n + S3_Mpr + S3_Mpdo;
  SC_M_n := mfmax[3]-(S3_Mi_n + S3_Md + S3_Mpt + S3_U_Mp_n);

  h := (hp+ha)/2;
  dh := ha-h;
  if h <> hold then
    begin{new max}
      maxanew := maxa - (h-hamin)*(maxa-maxaold)/(h-hold);
      hold := h;
      maxaold := maxa;
    end;{new max}

  writeln;
  writeln('Turn Time = ',tt:5:3,' s, Maximum angle of attack = ',
          maxa*180/pi:7:4,degc);
  writeln(S3_Name,' in Orbit! Remaining propellant = ',m0:1:0,' kg.');
  writeln('Perigee = ',(hp/1000):5:1,' km, Apogee = ',(ha/1000):5:1,
          ' km, Average Altitude = ',(h/1000):5:1,plmic,(dh/1000):3:1,' km');

  writeln('Vacuum and zero gravity delta-V = ',dv:1:0,' m/s');
  writeln('Stage 3 Maximum force = ',fmax[3]:1:0,' N at ',tfmax[3]:4:2,' s');
  writeln('Liftoff thrust = ',flo:1:0,' N at ',alo:5:2,' m/s',sqrc,
          ' for ',mlo:1:0,' kg');
  if simout then
    begin{output parameters}
      writeln('Maximum dynamic pressure = ',Pqmax:1:0,' Pa at ',tPqmax:5:2,
              ' s');
      writeln('Maximum acceleration = ',a_max:5:2,' m/s',sqrc,' at ',ta_max:5:2,
              ' s');
    end;{output parameters}
  writeln('  S3_Mt   = ',S3_Mt:7:0,
          '; {kg, interstage, third stage and payload mass}');
  assign(cfile,'const_n.pas');
  rewrite(cfile);
  writeln(cfile);
  writeln(cfile,'  {Stage 3 constants updated from simulation}');
  writeln(cfile,'  S3_Mi    =    ',S3_Mi_n:4:0,'; {kg, interstage mass}');
  writeln(cfile,'  S3_Mp    =  ',S3_Mp_n:6:0,
                '; {kg, mainstage propellant mass used, ',S3_Mpt:5:0,
                ' kg total -');
  writeln(cfile,'                           ',S3_Mpu:3,' kg unusable - ',
                S3_Mpr:3:0,' kg reserve - ',S3_Mpdo:3:0,' kg deorbit}');
  writeln(cfile,'  S3_Ms    =   ',S3_Ms_n:5:0,
                '; {kg, cutoff mass, ',S3_Md:5,' kg dry + ',S3_Mpu:4,
                ' kg unusable +');
  writeln(cfile,'                           ',S3_Mpr:3:0,' kg reserve + ',
                S3_Mpdo:3:0,' kg deorbit}');
  writeln(cfile,'  S3_U_Mp  =     ',S3_U_Mp_n:3:0,
                '; {kg, ullage and RCS propellant}');
  writeln(cfile,'  SC_M     =  ',SC_M_n:6:0,'; {kg, Spacecraft mass}');
  close(cfile);
  writeln('  SC_M    = ',SC_M_n:7:0,'; {kg, Spacecraft mass}');
  writeln;
  writeln('Recommended maxa = ',(maxanew*180/pi):7:4,degc);
  writeln;
end;{stage 3}
