{SLS Block IB constants. Steven S. Pietrobon  1 Mar 2016.
  1 Mar 2016 v1.00 First Release}

const Name = 'SLS Block IB';
  {Stage 1 constants}
  S1_Name =   'RSRMV';
  S1_Mp   =    632489; {kg, usable propellant mass}
  S1_Ms   =     96751; {kg, burnout mass}
  S1_N    =         2; {no. of boosters}
  S1_D    =    5.2883; {m,  aft-skirt diameter}
  S1_A    =    -0.038; {m^2, hold down posts and retrockets area less Core 
                            overlap area, 0.763 - 0.801 m^2}
  S1_De   =    3.8748; {m,  nozzle exit diameter}
  S1_V    =    2605.4; {m/s, vacuum exhaust speed}
  S1_Ta   =     128.4; {s,  action time}
 
  {Stage 2 constants}
  S2_Name =   'Core';
  S2_Mp1   =  958974; {kg, mainstage propellant mass used, 982663 kg total -
                           8437 kg startup - 14016 kg unusable - 1236 kg cutoff}
  S2_Mp2   =    1236; {kg, cut off propellant mass used}
  S2_Ms    =  114078; {kg, dry mass 100062 + 14016 kg unusable}
  S2_D     =   8.407; {m,  stage diameter}
  S2_A     =   2.073; {m^2, feed lines, engine fairings, and tunnel
                            2*0.608 + 4*0.203 + 0.045 m^2}
  S2_Ts    =    0.76; {s, separation time after MECO}

  {Stage 2 engine constants}
  S2_Eng_Name = 'RS-25D';
  S2_N     =       4; {no. of engines}
  S2_F     = 2090664; {N,   vacuum thrust}
  S2_Fs    = 1668298; {N,   sea level thrust}
  S2_V     = 4419.86; {m/s, vacuum exhaust speed}
  S2_I     =    0.01; {thrust incremental ratio}
  S2_R     =   1.091; {thrust ratio}

  {Stage 3 constants updated from simulation}
  S3_Mp    =   15591; {kg, mainstage propellant mass used, 16880 kg total -
                           1089 kg unusable - 145 kg reserve -  55 kg deorbit}
  S3_Ms    =    5120; {kg, cutoff mass,  3831 kg dry + 1089 kg unusable +
                           145 kg reserve +  55 kg deorbit}
  S3_U_Mp  =      71; {kg, ullage and RCS propellant}
  SC_M     =   89011; {kg, Spacecraft mass}

  {Other Stage 3 constants}
  S3_Name  = 'EUS';
  S3_T1    =     3.4; {s,  time to engine start}
  S3_T2    =     2.6; {s,  thrust build up time}
  S3_Ts    =     2.9; {s,  cutoff to seperation time}
  S3_D     =   8.407; {m,  stage diameter}
  S3_Mpu   =    1089; {kg, unusable propellant}
  S3_Md    =    3831; {kg, dry mass}
  S3_Mi    =    4581; {kg, interstage mass}

  {Stage 3 engine constants}
  S3_Eng_Name = 'RL10B-2';
  S3_N     =       1; {no. of engines}
  S3_De    =  2.1463; {m,   nozzle diameter}
  S3_F     =  110093; {N,   vacuum thrust}
  S3_V     =  4535.6; {m/s, vacuum exhaust speed}
  S3_Vs    =    0.01; {delta-V reserve increase}

  {Stage 3 ullage engine constants}
  S3_U_N   =       4; {m/s, Number of ullage engines}
  S3_U_F   =    4003; {N,   Ullage thrust, R-40B}
  S3_U_V   =  2873.3; {m/s, Ullage exhaust speed, R-40B}
  S3_U_De  =   0.040; {m,   Ullage nozzle diameter, R-40B}
  S3_U_T   =     0.2; {s,   Ullage start time after Core separation}
  S3_U_Mp1 = (S3_T1+S3_T2-S3_U_T)*S3_U_N*S3_U_F/S3_U_V; {ullage propellant mass}
  S3_U_Vs  =     0.1; {delta-V reserve increase}

  {Spacecraft constants}
  PLF_T    =     330; {s,  time to PLF jettison from launch}
  PLF_M    =    9707; {kg, Payload Fairing mass}

  {Launch constants}
  inc      =   28.45; {deg, Kennedy Space Center inclination}
  inc_orb  =   28.45; {deg, Target inclination for TLI}
  h_turn   =     110; {m,   pitch over altitude}
  angle1   =    -0.7; {deg, pitch over angle rate for stage 1}
  amax1    =   29.42; {m/s^2, maximum acceleration strain}
  hamin    =  200000; {m,   minimum orbital altitude}
  hpmax    =   37000; {m,   maximum perigee altitude}

var S3_Mt,S3_Mp_n,SC_M_n,S3_Mpr:double;