procedure stage1;
{Finds the trajectory of the SRBs for the Space Shuttle.
 Steven S. Pietrobon 21 Dec 1997. Revised  9 Feb 1998}
var ta,tb,tc,tt,tl,Fl,tn,Fn,dFt,dRpt:double;
    srb:text;

procedure read_srb;
{Read SRB. Steven S. Pietrobon 22 Dec 1997.}
begin{read srb}
  tl := tn;
  Fl := Fn;
  read(srb,tn);
  readln(srb,Fn);
  dt := tn - tl;
  if dt > 1.0 then
    begin{error}
      writeln('SRB time increments must be at most 1 second');
      goto 99;
    end;{error}
  dF := SRB_N*(Fn - Fl)/dt;
  dRp := -dF/SRB_Vv + dRpt;
  dF := dF + dFt;
end;{read srb}

procedure traj_time_srb;
{Read SRB. Steven S. Pietrobon 22 Dec 1997.}
begin{traj time srb}
  read_srb;
  Te := Te-dt;
  while Te > 0 do
    begin{traj}
      trajectory;
      read_srb;
      Te := Te-dt;
    end;{traj}
  ta := dt;
  dt := Te+dt;
  trajectory;
  dt := ta-dt;
end;{traj time srb}

begin{stage 1}
  assign(srb,'srb.dat');
  reset(srb);

  Ar := pi*(SRB_N*sqr(SRB_D) + sqr(ET_D))/4 + ET_A + ORB_A;
  Fd := SRB_N*pi*sqr(SRB_Dn)/4 + MPS_N*(SSME_Fv-SSME_Fs);
  Me := SRB_N*SRB_Ms + ET_Ms + OMS_Mp + ORB_M + PL_M;
  t0 := 0.0;
  x0 := 0.0;
  x1s := cos(inc*pi/180)*2*pi*Re/T;
  x1 := x1s;
  h0 := 0.0;
  h1 := 0.0;
  r0 := 0.0;
  p0 := 0.0;
  m0 := SRB_N*SRB_Mp + ET_Mp1 + ET_Mp2;
  dRp := 0.0;
  dF := 0.0;
  f0 := MPS_N*SSME_Fv*MPS_R0;
  m1 := -f0/SSME_Vv;
  write(t0:7:2,gs:6:1,round(x1s):6,round(h0):8,round(r0):10);
  writeln(90.0:7:2,0.0:7:2,90.0:7:2,0.0:9:1,m0+Me:10:1);

  write(question,'Turn time (s)? ');
  readln(tt);
  if tt < 0 then goto 99;

  read(srb,tn);
  readln(srb,Fn);
  dt := tn;
  dF := SRB_N*Fn/dt;
  dFt := 0.0;
  dRp := -dF/SRB_Vv;
  dRpt := 0.0;
  ta := -gs*dRp/2;
  tb := -gs*m1 + dF;
  tc := f0 - Fd - gs*(m0 + Me);
  t0 := (-tb + sqrt(tb*tb - 4*ta*tc))/(2*ta);
  m0 := m0 + t0*m1 + t0*t0*dRp/2;
  f0 := f0 + t0*dF;
  m1 := m1 + t0*dRp;
  write(t0:7:2,(f0-Fd)/(m0+Me):6:1,round(x1s):6,round(h0):8,round(r0):10);
  writeln(90.0:7:2,0.0:7:2,90.0:7:2,0.0:9:1,m0+Me:10:1);

  dt := dt - t0;
  dp := 0.0;
  traj := air;
  fair := true;
  trajectory;

  repeat
    read_srb;
    trajectory;
  until h0 > h_turn;
  dt := -dt;
  trajectory;
  Te := -dt;
  dt := -dt/10;
  hmax := h_turn;
  traj_height;
  dt := -dt/10;
  traj_height;

  writeln('Pitch over!');
  dp := angle1*pi/180;
  dt := Te;
  trajectory;
  Te := 1.0-dt;
  traj_time_srb;
  dp := 0.0;
  trajectory;
  Te := tt - dt;
  if Te < 0 then
    begin{error}
      writeln('Turn time must be at least 1 second');
      goto 99;
    end;{error}
  traj_time_srb;
  dp := -angle1*pi/180;
  trajectory;
  Te := 1.0-dt;
  traj_time_srb;

  writeln('End turn.');
  dp := 0.0;
  trajectory;
  Te := MPS_T1 - t0;
  traj_time_srb;

  writeln('SSME throttle down to ',round(100*MPS_R1):2,'%');
  Te := abs((MPS_R1-MPS_R0)*MPS_Tt1);
  dFt := (MPS_R1-MPS_R0)*MPS_N*SSME_Fv/Te;
  dF := dF + dFt;
  dRpt := -dFt/SSME_Vv;
  dRp := dRp + dRpt;
  trajectory;
  Te := Te - dt;
  traj_time_srb;

  writeln('End SSME throttle down');
  dF := dF - dFt;
  dFt := 0.0;
  dRp := dRp - dRpt;
  dRpt := 0.0;
  trajectory;
  Te := MPS_T2 - t0;
  traj_time_srb;

  writeln('SSME throttle up to ',round(100*MPS_R2):3,'%');
  Te := abs((MPS_R2-MPS_R1)*MPS_Tt2);
  dFt := (MPS_R2-MPS_R1)*MPS_N*SSME_Fv/Te;
  dF := dF + dFt;
  dRpt := -dFt/SSME_Vv;
  dRp := dRp + dRpt;
  trajectory;
  Te := Te - dt;
  traj_time_srb;

  writeln('End SSME throttle up');
  dF := dF - dFt;
  dFt := 0.0;
  dRp := dRp - dRpt;
  dRpt := 0.0;
  trajectory;
  while not(eof(srb)) do
    begin{srb burn}
      read_srb;
      trajectory;
    end;{srb burn}
  Fd := MPS_N*(SSME_Fv-SSME_Fs);
  dt := 1.0;
  dF := 0.0;
  dRp := 0.0;
  Te := SRB_Ts;
  fair := false;
  time_traj;

  writeln('SRB seperation!');
  close(srb);
end;{stage 1}
