{Space Shuttle constants. Steven S. Pietrobon 21 Dec 1997.
 Revised  7 Feb 1998}
const {SRB constants}
  SRB_Mp   =  501808; {kg, SRB propellant mass used}
  SRB_Ms   =   87714; {kg, SRB separation mass}
  SRB_N    =       2; {no. of SRBs}
  SRB_D    =  5.1562; {m,  SRB aft-skirt diameter}
  SRB_Dn   =  3.7846; {m,  SRB nozzle diameter}
  SRB_Vv  = 2636.826; {m/s, vacuum exhaust speed}
  SRB_Ts   =     2.0; {s,  SRB separation time}

  {ET constants}
  ET_Mp1   =  718298; {kg, mainstage propellant mass used}
  ET_Mp2   =     927; {kg, cut off propellant mass used}
  ET_Ms    =   37290; {kg, cutoff mass}
  ET_D     =  8.4074; {m,  ET diameter}
  ET_A     =    4.04; {m^2, miscellaneous ET cross-sectional area}

  {MPS constants}
  MPS_N    =       3; {no. of engines}
  MPS_T1   =      27; {s, change thrust to F1}
  MPS_T2   =      59; {s, change thrust to F2}
  MPS_T3   =     6.7; {s, time before start of MECO}
  MPS_Ts   =      18; {s, separation time after MECO}
  MPS_R0   =    1.00; {thrust ratio at T0}
  MPS_R1   =    0.65; {thrust ratio at T1}
  MPS_R2   =    1.04; {thrust ratio at T2}
  MPS_R3   =    0.65; {thrust ratio at T3}
  MPS_Tt1  =      10; {s, thrust bucket throttle down time for 100% thrust change}
  MPS_Tt2  =      15; {s, thrust bucket throttle up time for 100% thrust change}
  MPS_Tt3  =      10; {s, MECO throttle down time for 100% thrust change}

  {OMS constants}
  OMS_Mp   =    4691; {kg,  OMS propellant mass}
  OMS_F    =   26689; {N,   vacuum thrust}
  OMS_V    =    3065; {m/s, vacuum exhaust speed}
  OMS_N    =       2; {no.  of OMS engines}

  {Spacecraft constants}
  PL_M     =   24948; {kg,  Payload mass}
  ORB_M    =   89305; {kg,  Orbiter mass}
  ORB_A    =   69.86; {m^2, Orbiter cross-sectional area, estimated}

  {SSME constants.}
  SSME_Fv  = 2090664; {N,   vacuum thrust}
  SSME_Fs  = 1668083; {N,   sea level thrust}
  SSME_Vv  =    4444; {m/s, vacuum exhaust speed}
  SSME_I   =    0.01; {thrust incremental ratio}

  {Launch constants}
  inc      =   28.45; {deg, Kennedy Space Center inclination}
  h_turn   =      56; {m,   pitch over altitude}
  angle1   =    -1.0; {deg, pitch over angle rate for stage 1}
  amax1    =   29.42; {m/s^2, maximum acceleration strain}
  via      =  7890.9; {m/s, pre-transfer speed}
