procedure stage1;
{Finds the trajectory of an NSTO vehicle.
 Steven S. Pietrobon 21 Dec 1997. Revised 7 Mar 1999, 6 Jan 2000, 5 May 2010}
var Fv,dtt,dFt,dRpt,Rd,mp,mf,dv,mf2,mp2,dv2:double;
    pd,Id,VR,m_O,m_F,V_p,V_O,V_F,R_v,m_t,m_e,m_v,m_c:double;
    I,J:integer;
    engine:array[1..MPS_N] of integer;

begin{stage 1}
  J := MPS_N div 2;
  for I := 1 to MPS_N do
    if I mod 2 = 1
      then engine[I] := I
      else engine[I] := ((I+J-2) mod (2*J))+1;
  pd := (MR+1)/(MR/pdO+1/pdF);
  Id := Vv*pd;
  Fv := SSME_Fv*(Id/Id1);
  Ar := pi*(sqr(ET_D) + sqr(PL_D))/4 + ET_A;
  Fd := MPS_N*(SSME_Fv-SSME_Fs);
  Me := ET_Ms + PL_M + OMS_Mp;
  t0 := 0.0;
  x0 := 0.0;
  x1s := cos(inc*pi/180)*2*pi*Re/T;
  x1 := x1s;
  h0 := 0.0;
  h1 := 0.0;
  r0 := 0.0;
  p0 := 0.0;
  dRp := 0.0;
  dF := 0.0;
  f0 := MPS_N*Fv*MPS_R0;
  m0 := (f0-Fd)/a0 - Me;
  m1 := -f0/Vv;
  mp := m0;
  write(t0:7:2,gs:6:1,round(x1s):6,round(h0):8,round(r0):10);
  writeln(90.0:7:2,0.0:7:2,90.0:7:2,0.0:9:1,m0+Me:10:1);

  dt := 1.0;
  dF := 0.0;
  dRp := 0.0;
  dp := 0.0;
  traj := air;
  fair := true;
  hmax := h_turn;
  traj_height;
  dt := 0.1;
  traj_height;
  dt := 0.01;
  traj_height;

  writeln('Pitch over!');
  dp := angle1*pi/180;
  dt := 1.0;
  trajectory;
  dp := 0.0;
  Te := tt;
  time_traj;
  dp := -angle1*pi/180;
  dt := 1.0;
  trajectory;

  writeln('End turn.');
  dp := 0.0;
  Te := (f0/amax1 - m0 - Me)/m1;
  time_traj;

  writeln('Maximum acceleration reached!');
  write(question,'Maximum angle of attack? ');
  readln(maxa);
  maxa := maxa*pi/180;
  traj := orb;
  iorb := true;
  pow := 2.0;

  dtt := MPS_Tt*SSME_I;
  dFt := -MPS_N*Fv/MPS_Tt;
  dRpt := -dFt/Vv;
  Rd := MPS_R0;
  repeat
    dt := dtt;
    dF := dFt;
    dRp := dRpt;
    trajectory;
    Rd := Rd - SSME_I;
    dt := 1.0;
    dF := 0.0;
    dRp := 0.0;
    Te := (f0/amax1 - m0 - Me)/m1;
    time_traj;
  until Rd < MPS_R1+epsilon;

  I := 1;
  repeat
    writeln('Engine ',engine[I],' cutoff!');
    dt := MPS_Tc;
    dF := -Fv*MPS_R1/dt;
    dRp := -dF/Vv;
    trajectory;
    Fd := Fd - (SSME_Fv-SSME_Fs);
    dt := 1.0;
    dF := 0.0;
    dRp := 0.0;
    Te := (f0/amax1 - m0 - Me)/m1;
    tt := (exp(m1*(via-vi)/f0)-1)*(m0+Me)/m1;
    if Te < tt 
      then time_traj
      else begin{maxv}
             repeat
               trajectory
             until vi > via;
             dt := -dt;
             trajectory;
             dt := (exp(m1*(via-vi)/f0)-1)*(m0+Me)/m1;
             trajectory;
           end;{maxv}
    I := I+1;
  until (I > MPS_N) or (tt < Te);
  writeln('Main Engine Cutoff (MECO)!');

  mp := mp - m0;
  mf := Me + m0;
  dv := Vv*ln(1+mp/mf);
  mf2 := mf*exp(-MPS_oh*dv/Vv);
  mp2 := mp + mf - mf2;
  dv2 := (1+MPS_oh)*dv;
  write('Perigee = ',(hp/1000):5:1,' km, ');
  write('Apogee = ',(ha/1000):5:1,' km, ');
  writeln('Average Altitude = ',(hp+ha)/2000:5:1,' km');
  write('MR = ',MR:3:1,', d_p = ',pd:6:4,' kg/L, ');
  writeln('ve = ',round(Vv):1,' m/s, I_d = ',round(Vv*pd):1,' Ns/L');
  write('Delta V = ',round(dv):1,' m/s, m_i = ',round(mp+mf):1,' kg, ');
  V_p := mp2/pd;
  writeln('V_p = ',round(V_p):1,' L, m_f = ',round(mf2):1,' kg');
  m_O := mp2/(1+1/MR);
  m_F := mp2/(1+MR);
  write('m_O = ',round(m_O):1,' kg, m_F = ',round(m_F):1,' kg, ');
  VR := pdF*MR/pdO;
  V_O := V_p/(1+1/VR);
  V_F := V_p/(1+VR);
  writeln('V_O = ',round(V_O):1,' L, V_F = ',round(V_F):1,' L');
  m_t := 27.0*exp(0.843*ln(1.02*V_O/1000));
  if pdF < 0.2
    then m_t := m_t + 32.3*exp(0.795*ln(1.02*V_F/1000))
    else m_t := m_t + 30.5*exp(0.824*ln(1.02*V_F/1000));
  R_v := SSME_Fv/Id1;
  m_e := MPS_N*R_v*(2.3+2e-7*Id*R_v);
  m_v := 3.15*(m_t+m_e);
  m_c := mf2-m_v;
  write('m_t = ',round(m_t):1,' kg, m_e = ',round(m_e):1,' kg, ');
  writeln('m_v = ',round(m_v):1,' kg, m_c = ',round(m_c):1,' kg');
end;{stage 1}
