{Propellant procedure. Steven S. Pietrobon  6 Jan 2000.}
type chemical = (O2,H2O2_98,H2,CH4,C2H6,C3H8,RP1,C3H4,C7H8);
     propellant = record
                    oxidiser:O2..H2O2_98;
                    fuel:H2..C7H8;
                    MR_:double; {oxidiser to fuel mixture ratio}
                    ve:double; {vacuum exhaust speed, m/s}
                  end;

var prop:integer;
    Vv,Id1,MR,pdO,pdF:double;
    customfile:text;
    custom:string;

procedure init_propellant;
const density:array[chemical] of double = (1.149,1.42975,
                0.0709,0.4239,0.57,0.5853,0.8,0.7,0.985);
      names:array[chemical] of string = ('O2','98%H2O2',
                'H2','CH4','C2H6','C3H8','RP-1','C3H4','C7H8');
      num_prop = 11;
      mixture:array[1..num_prop] of propellant = 
             ((oxidiser:O2;      fuel:H2;   MR_:6.0; ve:4444),
              (oxidiser:O2;      fuel:H2;   MR_:7.5; ve:4365),
              (oxidiser:O2;      fuel:CH4;  MR_:3.6; ve:3656),
              (oxidiser:O2;      fuel:C2H6; MR_:3.2; ve:3634),
              (oxidiser:O2;      fuel:C3H8; MR_:3.1; ve:3613),
              (oxidiser:O2;      fuel:C3H4; MR_:2.4; ve:3696),
              (oxidiser:O2;      fuel:RP1;  MR_:2.8; ve:3554),
              (oxidiser:O2;      fuel:C7H8; MR_:2.4; ve:3628),
              (oxidiser:H2O2_98; fuel:C3H4; MR_:6.5; ve:3319),
              (oxidiser:H2O2_98; fuel:RP1;  MR_:7.3; ve:3223),
              (oxidiser:H2O2_98; fuel:C7H8; MR_:6.6; ve:3288));
begin{init propellant}
  writeln;
  writeln('0=custom');
  prop := 1;
  repeat
    with mixture[prop] do 
      writeln(prop:1,'=',names[oxidiser],'/',names[fuel],'(',MR_:3:1,')');
    prop := prop+1;
  until prop > num_prop;
  write('Enter propellant choice: ');
  readln(prop);
  if prop = 0
    then begin{input prop}
           write('Create file of custom propellant with the following ');
	     writeln('parameters');
           writeln('Oxidiser density (kg/L)');
           writeln('Fuel density (kg/L)');
           writeln('Mixture ratio (MR)');
           writeln('Vacuum exhaust speed (m/s)');
	     write('Enter file name of custom propellant: ');
	     readln(custom);
	     assign(customfile,custom);
	     reset(customfile);
           readln(customfile,pdO);
           readln(customfile,pdF);
           readln(customfile,MR);
           readln(customfile,Vv);
	     close(customfile);
         end{input prop}
    else with mixture[prop] do
           begin{calc prop}
             MR := MR_;
             Vv := ve;
             pdO := density[oxidiser];
             pdF := density[fuel];
           end;{calc prop}
  with mixture[1] do
    Id1 := ve*(MR_+1)/(MR_/density[oxidiser]+1/density[fuel]);
end;{init propellant}
