program fh(input,output);
{Determines FH payload for a given delta-V
 27 Mar 2019 Updated constants.}

const mc0 =  63.8; {t, payload to LEO}
      n   =     3; {number of payloads}
      mc1:array[0..2] of double
          = (26.7,16.8,3.5); {t, payload to Pluto, Mars, GTO}
      dv1:array[0..2] of double
          = (2440,3600,8360); {m/s, delta-V to Pluto, Mars, GTO}
      ms =    4.0; {t, upper stage dry mass}
      mp =  107.5; {t, propellant mass}
      ve = 3412.7; {m/s, exhaust speed}
      vi = ve*ln(1+mp/(ms+mc0)); {reference speed}

var dv,mc,vm:double;
    I:integer;

begin{fh}
  vm := 0;
  for I := 0 to n-1 do
    vm := vm + (ve*ln(1+mp/(ms+mc1[I]))-vi)/dv1[I];
  vm := vm/n;
  repeat
    write('Enter Delta-V from LEO in m/s: ');
    readln(dv);
    if dv >= 0 then
      begin{new dv}
        mc := mp/(exp((vm*dv+vi)/ve)-1)-ms;
        writeln('Payload mass = ',mc:4:2,' t');
        writeln;
      end;{new dv}
  until dv < 0;
end.{fh}