program f9(input,output);
{Determines expendable Falcon 9 payload for a given delta-V}

const mc0 =   22.8; {t, payload to LEO}
      mc1 =    8.3; {t, payload to GTO}
      dv1 = 2477.8; {m/s, delta-V to GTO}
      ms =     4.0; {t, upper stage dry mass}
      mp =   107.5; {t, propellant mass}
      ve =  3383.3; {m/s, exhaust speed}
      vi = ve*ln(1+mp/(ms+mc0)); {reference speed}

var dv,mc,vm:double;

begin{f9}
  vm := (ve*ln(1+mp/(ms+mc1))-vi)/dv1;
  repeat
    write('Enter Delta-V from LEO in m/s: ');
    readln(dv);
    if dv >= 0 then
      begin{new dv}
        mc := mp/(exp((vm*dv+vi)/ve)-1)-ms;
        writeln('Payload mass = ',mc:5:3,' t');
        writeln;
      end;{new dv}
  until dv < 0;
end.{f9}